# -*- coding:utf-8 -*-

import os
import sys
import unittest

TEST_DIR = os.path.dirname(os.path.realpath(__file__))
sys.path.append(TEST_DIR + '/../bin')

script = __import__("show-auto-supbs-diff-in-issues")

"""
Тесты на метод compare скрипта ../bin/show-auto-supbs-diff-in-issues.py
запуск:
python test_compare_in_show_auto_supbs_diff_in_issues.py
"""

FIRST_COMMIT = u"""**OrderID = 20598566**
<{OrderInfo
%%
    bla bla
    какое-то описание на русском
    GroupOrderID = 20463667
    end of bla bla%%}>
**((https://bsinfo.yandex.ru BsInfo))**
<{Также вам могут пригодиться следующие запросы
<{bs-filter-log
%%bla bla%%
}>
<{bs-match-log
%%
bla bla
        %%
}>
}>
"""

EXPECTED_DIFF_IN_COLLAPSE_BLOCK = u"""**!!(крас)есть разница в данных:!!** <{OrderInfo
%%(diff)
      bla bla
      какое-то описание на русском
-     GroupOrderID = 20463667
?                     --- ---
+     GroupOrderID = -123
?                    ++
      end of bla bla
%%}>
"""


class CompareMethodTest(unittest.TestCase):
    def test_equal_comments(self):
        self.failUnlessEqual(script.compare(FIRST_COMMIT, FIRST_COMMIT), "")

    def test_diff_in_collapse_block(self):
        last_commit = FIRST_COMMIT.replace("20463667", "-123")
        self.failUnlessEqual(script.compare(FIRST_COMMIT, last_commit), EXPECTED_DIFF_IN_COLLAPSE_BLOCK)

    def test_diff_with_new_block_in_last_comment(self):
        new_block = u"**Новый блок**\n"
        last_commit = new_block + FIRST_COMMIT

        expected_diff = u"**!!(зел)добавлено:!!** " + new_block
        self.failUnlessEqual(script.compare(FIRST_COMMIT, last_commit), expected_diff)

    def test_diff_with_delete_block_in_first_comment(self):
        deleted_block = "**((https://bsinfo.yandex.ru BsInfo))**\n"
        last_commit = FIRST_COMMIT.replace(deleted_block, "")

        expected_diff = u"**!!(крас)удалено:!!** " + deleted_block
        self.failUnlessEqual(script.compare(FIRST_COMMIT, last_commit), expected_diff)

    def test_skip_diff_in_ignore_block(self):
        # ожидается, что блок со справочной информацией в конце не будет сраниваться
        last_commit = FIRST_COMMIT.replace("bs-filter-log", "")

        self.failUnlessEqual(script.compare(FIRST_COMMIT, last_commit), "")


if __name__ == '__main__':
    unittest.main()
