package DirectReleaseTesting;

use strict;
use warnings;

use File::Temp qw/ tempfile tempdir /;
use FindBin qw/$Bin/;

use parent qw/Exporter/;

our @EXPORT = qw(
    write_file
    prepare_tmp_dir
    clear_state
);

#our %conf = (
#    apps => { 
#        app1 => {
#            'package-json' => 'package-app1.json',
#            'package' => 'package-app1',
#            'tracker-component' => 'component_1',
#        }
#    },
#    external_programs => {
#        'create-sandbox-task' => 'mock-create-sandbox-task',
#        'wait-dist' => 'mock-wait-dist',
#        'wait-packages' => 'mock-wait-packages',
#        'dmove' => 'mock-dmove',
#        'update-java-ts' => 'mock-update-java-ts',
#        'write-tracker' => 'mock-write-tracker',
#        'hotfix-merge' => 'mock-hotfix-merge',
#    },
#
#);

sub write_file
{
    my ($filename, $cont) = @_;
    open(my $fh, ">", $filename);
    print $fh $cont;
}

sub read_file
{
    die;
}

sub clear_state
{
    my ($dir, $app) = @_;
    write_file("$dir/state/testing/$app", "{}");
    write_file("$dir/state/stable/$app", "{}");
    `rm -f $dir/state/waiting/$app/* || true`;
}

sub prepare_tmp_dir
{
    my $app = shift;

    $ENV{PATH} = (__FILE__ =~ s!/[^/]*$!!r)."/../external-programs/:$ENV{PATH}";

    my $dir = tempdir( CLEANUP => 1 );
    mkdir("$dir/state") or die;
    mkdir("$dir/state/testing") or die;
    mkdir("$dir/state/stable") or die;
    mkdir("$dir/state/waiting") or die;
    mkdir("$dir/state/waiting/$app") or die;
    my $apps_conf = {
        apps => { 
            app1 => {
                'package-json' => 'package-app1.json',
                'package' => 'package-app1',
                'tracker-component' => 'component_1',
            }
        }
    };

    write_file("$dir/apps.conf.yaml", YAML::Dump($apps_conf));

    my $test_conf = {
        apps_conf_file => "$dir/apps.conf.yaml",
        state_dir => "$dir/state",
        external_programs => {
            'get-prod-version-zk' => 'mock-get-prod-version-zk',
            'create-sandbox-task' => 'mock-create-sandbox-task',
            'wait-dist' => 'mock-wait-dist',
            'wait-packages' => 'mock-wait-packages',
            'dmove_testing' => 'mock-dmove_testing',
            'dmove_stable' => 'mock-dmove_stable',
            'update-java-ts' => 'mock-update-java-ts',
            'write-tracker' => 'mock-write-tracker',
            'hotfix-merge' => 'mock-hotfix-merge',
            'change-issue-status-or-comment' => 'mock-change-issue-status-or-comment',
            'release-ticket-report' => 'mock-release-ticket-report',
            'find-packages-to-dmove' => 'mock-find-packages-to-dmove',
            'create-master-connection' => 'mock-create-master-connection',
            'dmove-dependencies' => 'mock-dmove-dependencies',
            'svn-info' => ['mock-svn-info'],
            'get-changelog' => 'mock-get-changelog',
            'wait-changelog' => 'mock-wait-changelog'
        },
    };
    write_file("$dir/test.conf.yaml", YAML::Dump($test_conf));

    clear_state($dir, "app1");

    return $dir;
}


1;
