package DirectReleaseTesting::Sequence;

=head1 DESCRIPTION

    Функции для тестирования последовательностей действий

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;

use DirectReleaseTesting;

use parent qw/Exporter/;
our @EXPORT = qw(
);

our $DIRECT_RELEASE_PATH = (__FILE__ =~ s!/[^/]*$!!r)."/../../../bin/direct-release";

sub run_one_testcase_positive
{
    my ($tc, $dir) = @_;

    my @stages = @{ $tc->{stage} || ['testing', 'stable'] };
    for my $stage ( @stages ){
        clear_state($dir, "app1");

        my $title = $tc->{title};
        $title ||= join(", ", @{$tc->{actions}});
        $title .= "\@$stage ok";
        for my $action ( @{$tc->{actions}} ){
            my $todo;
            if ( ref $action eq 'HASH' ){
                $todo = $action->{todo};
                for my $var (keys %{$action->{env}||{}}){
                    $ENV{$var} = $action->{env}->{$var};
                }
            } else {
                $todo = $action;
            }
            #my $cmd = "$Bin/../bin/direct-release -s $stage -a app1 -t $dir/test.conf.yaml $todo";
            my $cmd = "$DIRECT_RELEASE_PATH -s $stage -a app1 -t $dir/test.conf.yaml $todo";
            my $c = system("$cmd >&2");
            ok($c == 0, "$title: $todo");
            if ( ref $action eq 'HASH' ){
                for my $var (keys %{$action->{env}||{}}){
                    delete $ENV{$var};
                }
            }
        }
    }
}

sub run_one_testcase_negative
{
    my ($tc, $dir) = @_;

    my @stages = @{ $tc->{stage} || ['testing', 'stable'] };
    for my $stage ( @stages ){
        clear_state($dir, "app1");

        my $title = $tc->{title};
        $title ||= join(", ", @{$tc->{actions}});
        $title .= "\@$stage must die";
        dies_ok{
            for my $action ( @{$tc->{actions}} ){
                my $todo;
                if ( ref $action eq 'HASH' ){
                    $todo = $action->{todo};
                    for my $var (keys %{$action->{env}||{}}){
                        $ENV{$var} = $action->{env}->{$var};
                    }
                } else {
                    $todo = $action;
                }
                #my $cmd = "$Bin/../bin/direct-release -s $stage -a app1 -t $dir/test.conf.yaml $todo";
                my $cmd = "$DIRECT_RELEASE_PATH -s $stage -a app1 -t $dir/test.conf.yaml $todo";
                my $c = system("$cmd >&2");
                if ( ref $action eq 'HASH' ){
                    for my $var (keys %{$action->{env}||{}}){
                        delete $ENV{$var};
                    }
                }
                die unless $c == 0;
            }
        } $title;
    }
}


sub run_tests
{
    my ($app, $testcases, $global_test_type) = @_;

    my $dir = prepare_tmp_dir($app);

    for my $tc ( @$testcases ){
        my $type = $tc->{type} || $global_test_type || '';
        if ( $type eq 'positive' ){
            run_one_testcase_positive($tc, $dir);
        } elsif ( $type eq 'negative' ){
            run_one_testcase_negative($tc, $dir);
        } else {
            die "unknown type for tests: '$type'";
        }
    }
}


=head2

    выбрать из тесткейсов только те, чьи названия есть в массиве @$titles
    Если в $titles пустой массив -- вернет пустой массив
    Если в $titles undef -- вернет исходный список без фильтрации

=cut
sub filter_tests
{
    my ($testcases, $titles) = @_;

    return $testcases unless defined $titles;

    my %filter = map { $_ => 1 } @$titles;
    my $filtered = [];
    for my $t (@$testcases){
        next unless $filter{$t->{title} // '' };
        push @$filtered, $t;
    }
    return $filtered;
}


1;
