use strict;
use warnings;

=head1 TODO

    - тесты на специфические java- и perl- сценарии
    - убедиться, что подменяются все внешние команды (обнулять список)

=cut

use FindBin qw/$Bin/;
#use Test::More;
#use Test::Exception;
use YAML;
use Test::More;

use lib "$Bin/lib";
use DirectReleaseTesting;
use DirectReleaseTesting::Sequence;

my @test_cases_correct = (

    # создание релизов
    {
        title => 'create-release',
        stage => ['testing'],
        actions => [
            'create-release',
            'finish',
        ],
    },
    {
        title => 'create-release + hotfix',
        stage => ['testing'],
        actions => [
            'create-release',
            'hotfix 12345',
            'finish',
        ],
    },
#    {
#        title => 'create-release + slide',
#        stage => ['testing'],
#        actions => [
#            'create-release',
#            'slide',
#            'finish',
#        ],
#    },
#    {
#        title => 'create-release + slide + hotfix',
#        stage => ['testing'],
#        actions => [
#            'create-release',
#            'slide',
#            'hotfix 12345',
#            'finish',
#        ],
#    },
    {
        title => 'create-release + hotfix x N',
        stage => ['testing'],
        actions => [
            'create-release',
            'hotfix 12345',
            'hotfix 12345',
            'hotfix 12345',
            'finish',
        ],
    },
    {
        title => 'create-release x N',
        stage => ['testing'],
        actions => [
            'create-release',
            'finish',
            'create-release',
            'finish',
            'create-release',
            'finish',
        ],
    },
#    {
#        title => 'create-release, slide, hotfix x N',
#        stage => ['testing'],
#        actions => [
#            'create-release',
#            'finish',
#            'create-release',
#            'slide',
#            'finish',
#            'create-release',
#            'hotfix 12345',
#            'finish',
#        ],
#    },

    # работа с старыми релизами
    {
        title => 'open-release',
        actions => [
            # должен быть транковый релиз 
            'open-release D-712',
        ],
    },
    {
        title => 'open-release',
        actions => [
            # должен быть бранчевый релиз 
            'open-release D-1312',
        ],
    },
#    {
#        title => 'open + slide',
#        actions => [
#            'open-release D-712',
#            'slide',
#        ],
#    },
    {
        title => 'open-release + hotfix',
        actions => [
            'open-release D-712',
            {
                todo => 'hotfix 1239',
                env => {
                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
                },
            },
        ],
    },
#    {
#        title => 'open-release + slide + hotfix',
#        actions => [
#            'open-release D-712',
#            'slide',
#            {
#                todo => 'hotfix 12345',
#                env => {
#                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
#                },
#            },
#        ],
#    },
    {
        title => 'open-release + hotfix x N',
        actions => [
            'open-release D-712',
            {
                todo => 'hotfix 12345',
                env => {
                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
                },
            },
            {
                todo => 'hotfix 12345',
                env => {
                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
                },
            },
            {
                todo => 'hotfix 12345',
                env => {
                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
                },
            },
        ],
    },
    {
        title => 'open-release x N',
        stage => ['stable'],
        actions => [
            'open-release D-712',
            'open-release D-712',
            'open-release D-712',
        ],
    },
#    {
#        title => 'open-release, slide, hotfix x N',
#        stage => ['stable'],
#        actions => [
#            'open-release D-712',
#            'open-release D-712',
#            'slide',
#            'open-release D-712',
#            {
#                todo => 'hotfix 12345',
#                env => {
#                    GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
#                },
#            },
#        ],
#    },

    # finish
    {
        title => 'finish + closed',
        stage => ['stable', 'testing'],
        actions => [
            'open-release CLOSED-1',
            'finish',
        ],
    },
    {
        title => 'finish + needAcceptance',
        stage => ['stable', 'testing'],
        actions => [
            'open-release NEEDACCTEPTANCE-1',
            'finish',
        ],
    },
    {
        title => 'finish + rmAcceptance',
        stage => ['stable', 'testing'],
        actions => [
            'open-release RMACCTEPTANCE-1',
            'finish',
        ],
    },
    {
        title => 'finish + any status',
        stage => ['stable'],
        actions => [
            'open-release ST-1',
            'finish',
        ],
    },

    # разное
    {
        actions => ['what-to-do'],
    },
    {
        title => 'unfinished release + what-to-do',
        actions => [
            'open-release D-712',
            'what-to-do',
        ],
    },
    {
        actions => ['list-apps'],
    },
    {
        actions => ['overview'],
    },
    {
        stage => ['testing'],
        actions => ['inspect-issue'],
    },
    {
        title => 'clear sandbox task after creating',
        stage => ['testing'],
        actions => [
            'declare-release',
            'create-sandbox-task',
            'clear-sandbox-task',
        ],
    },
    {
        title => 'create-release + testing-to-stable',
        stage => ['testing'],
        actions => [
            'create-release',
            'testing-to-stable',
        ],
    },
    {
        title => 'open-release + dmove',
        stage => ['testing', 'stable'],
        actions => [
            'open-release ST-1',
            'dmove',
        ],
    },
);


my @test_cases_incorrect = (
    {
        title => 'hotfix with small revision',
        stage => ['testing'],
        actions => [
            'create-release',
            'hotfix 123',
            'finish',
        ],
    },
    {
        title => 'slide after hotfix',
        actions => [
            'create-release',
            'hotfix 12345',
            'what-to-do',
            'slide',
        ],
    },
    {
        title => 'hotfix w/o revision',
        actions => [
            'create-release',
            'hotfix',
        ],
    },
    {
        title => 'slide after finishing',
        actions => [
            'create-release',
            'finish',
            'slide',
        ],
    },
    {
        title => 'hotfix after finishing',
        actions => [
            'create-release',
            'finish',
            'hotfix 12345',
        ],
    },
    {
        title => 'hotfix for closed release in testing',
        stage => ['testing'],
        actions => [
            'open-release CLOSED-1',
            'hotfix 12345',
        ],
    },
    {
        title => 'hotfix for old release in stable',
        stage => ['stable'],
        actions => [
            'open-release CLOSED-1',
            {
                todo => 'hotfix 1239',
                env => {
                    GET_PROD_VERSION_ZK => "1.1250.1236-1\ntime=2018-07-12T17:31:58+0300",
                },
            },
        ],
    },
    {
        title => 'create-release w/o finishing previous release',
        actions => [
            'create-release',
            'create-release',
        ],
    },
    {
        title => 'open-release w/o finishing previous release',
        stage => ['testing'],
        actions => [
            'open-release D-712',
            'open-release D-1312',
        ],
    },
    {
        title => 'open-release with wrong component',
        actions => [
            'open-release COMP-2',
        ],
    },

    {
        title => 'finish + new',
        stage => ['testing'],
        actions => [
            'open-release NEW-1',
            'finish',
        ],
    },
    {
        title => 'finish + any status',
        stage => ['testing'],
        actions => [
            'open-release ST-1',
            'finish',
        ],
    },
    {
        title => 'clear-sandbox-task not after create-sandbox-task',
        stage => ['testing'],
        actions => [
            'what-to-do',
            'clear-sandbox-task',
        ],
    },
);

# для команды ensure-screen-tmux
$ENV{'TMUX'} = "for_testing";

my $to_run;
$to_run = 1 ? \@test_cases_correct : DirectReleaseTesting::Sequence::filter_tests(\@test_cases_correct, 
    [
    ],
);

DirectReleaseTesting::Sequence::run_tests( "app1", $to_run, 'positive' );


$to_run = 1 ? \@test_cases_incorrect : DirectReleaseTesting::Sequence::filter_tests(\@test_cases_incorrect, 
    [
        #'hotfix for closed release in testing',
    ],
);

DirectReleaseTesting::Sequence::run_tests( "app1", $to_run, 'negative' );

done_testing();

