use strict;
use warnings;

=head1 DESCRIPTION


=cut

use FindBin qw/$Bin/;
use YAML;
use Test::More;

use lib "$Bin/../lib";
use DirectReleaseTesting;
use DirectReleaseTesting::Sequence;

my @possible_after_finish = (qw/
finish
gpg-cache
inspect-issue 
list-apps
overview 
show-state
what-to-do 
zookeeper-info 
/,
'open-release ST-1',
'sleep 1',
'rename "new name"',
);
#test-update -- TODO научить test-update работать без done.dmove

my @disallowed_after_finish = (
    {
        todo => 'hotfix 1239',
        env => {
            GET_PROD_VERSION_ZK => "1.1234.1236-1\ntime=2018-07-12T17:31:58+0300",
        },
    },
);

# генерируем тесты "команду $cmd можно выполнить на зафинишенном релизе"
my @test_cases;
for my $cmd ( @possible_after_finish ){
    my $cmd_str = ref $cmd eq 'HASH' ? $cmd->{todo} : $cmd;
    push @test_cases, {
        title => "autogenerated: finish + $cmd_str (positive)",
        type => 'positive',
        actions => [
            'open-release D-712',
            'finish',
            $cmd,
        ],
    };
}

for my $cmd ( @disallowed_after_finish ){
    my $cmd_str = ref $cmd eq 'HASH' ? $cmd->{todo} : $cmd;
    push @test_cases, {
        title => "autogenerated: finish + $cmd_str (negative)",
        type => 'negative',
        actions => [
            'open-release D-712',
            'finish',
            $cmd,
        ],
    };
}



my $to_run;
$to_run = 1 ? \@test_cases : DirectReleaseTesting::Sequence::filter_tests(\@test_cases, 
    [
    ],
);

DirectReleaseTesting::Sequence::run_tests( "app1", $to_run );

done_testing();

