# -*- coding: utf8 -*-

import threading
import zookeeper

def zk_sync_init(host, fn=None, recv_timeout=10000, clientid=None):
    """
    copy-paste из zkdelivery.py + установка уровня логирования в WARN
    Синхронный вариант коннекта к zookeeper - возврат происходит либо
    после успешного коннекта, либо по истечении таймаута
    Параметры аналогичны zookeeper.init
    """
    zookeeper.set_debug_level(zookeeper.LOG_LEVEL_WARN)
    cv = threading.Condition()
    def watcher(handle, type, state, path):
        if fn:
            fn(handle, type, state, path)
        cv.acquire()
        cv.notifyAll()
        cv.release()
    cv.acquire()
    zkh = zookeeper.init(host, watcher, recv_timeout, clientid if clientid else (-1, ""))
    cv.wait(3.0 * recv_timeout / 1000 if recv_timeout else 60)
    cv.release()
    return zkh


