#!/bin/bash
#Скрипт для включения редиректа mysql порта 3307->3306

errorf() {
    /bin/echo "error execute ip6tables"
    exit 1
}

OUT=$(/sbin/ip6tables -t nat -L REDIRECT-OUT)
/bin/echo $OUT | /bin/grep -q "Chain REDIRECT-OUT" || errorf


case $1 in
    add)
        /bin/echo $OUT | /bin/grep -q "tcp dpt:3307 to::3306" && /bin/echo "found redirect port 3307->3306, skip add" && exit 0
        /sbin/ip6tables -t nat -A REDIRECT-OUT -p tcp --dport 3307 -j DNAT --to-destination :3306
        ;;
    delete)
        /bin/echo $OUT | /bin/grep -q "tcp dpt:3307 to::3306" &&
            /sbin/ip6tables -t nat -D REDIRECT-OUT -p tcp --dport 3307 -j DNAT --to-destination :3306 ||
            /bin/echo "not found redirect port 3307->3306, skip delete"
        ;;
    list)
        /sbin/ip6tables -t nat -L REDIRECT-OUT
        ;;
    *)
        /bin/echo "$0 add/delete/list - add redirect/delete redirect/show redirects"    
        ;;
esac
