#!/bin/bash -ex
# годится для back-to-back: запустить на старой версии, на новой, сравнить вывод 
# ./t/dbs-good-params.sh ./bin/dbs > file.txt

# определения БД
$1 mysql-shell ts:ppc:1 -n 
$1 mysql-shell ts:ppc:{1,2,5} -n 
$1 mysql-shell ts:ppc:all -n 
$1 mysql-shell ts:ppc:2 ts:ppc:5 -n 

# стратегии выполнения
$1 innotop ts:ppc:1 -n 
$1 innotop ts:ppc:1 --show -n 
$1 innotop ts:ppc:1 --tmux -n 
$1 innotop ts:ppc:1 --tmux-attached -n 
$1 innotop ts:ppc:1 --tmux-detached -n 
$1 innotop ts:ppc:1 --seq -n 

# действия
$1 pt-osc ts:ppc:12 'ALTER TABLE camp_options FORCE;' -n
$1 pt-osc ts:ppc:{11,12} 'ALTER TABLE camp_options FORCE;' --recursion-method none --no-auto-finish --no-check-alter --max-lag 301 --check_interval 2 -n  
$1 guard ts:ppc:1 -n 
$1 guard ts:ppc:all -n 
$1 innotop ts:ppc:1 -n 
$1 innotop ts:ppc:{1,4,5} -n 
$1 live-alter 'alter table t1 drop column c1' ts:ppcdict -n 
$1 sql ts:ppc:6 'show tables' -n 
$1 sql ts:ppc:6 ts:ppc:2 'show tables' -n 
$1 mysql-shell ts:ppc:4 -n 
$1 mysql-shell ts:ppc:4 ts:ppc:8 ts:ppc:7 -n 

# отделение БД от запроса
$1 sql 'select now()' ts:ppc:all -n
$1 sql ts:ppc:5 'select now()' ts:ppc:7 ts:ppc:8 -n
$1 sql ts:ppc:all 'select now()' -n
$1 sql ts:ppc:all -q 'select now()' -n
$1 sql -q 'select now()' ts:ppc:all -n
$1 sql ts:ppc:5 -q 'select now()' ts:ppc:7 ts:ppc:8 -n


# sql
$1 sql ts:ppc:all 'select * from t1' -n
$1 sql ts:ppc:1   'select * from t1' -B -n
$1 sql ts:ppc:all 'select * from t1' -B -n
$1 sql ts:ppc:all 'select * from t1' -quick -n
$1 sql ts:ppc:1   'select * from t1' -quick -B -n
$1 sql ts:ppc:all 'select * from t1' -quick -B -n

