CREATE TABLE `addresses` (
  `aid` int(10) unsigned NOT NULL,
  `ClientID` int(11) NOT NULL,
  `map_id` int(11) DEFAULT NULL,
  `map_id_auto` int(11) DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `metro` int(10) unsigned DEFAULT NULL,
  `ahash` bigint(20) unsigned NOT NULL,
  `kind` enum('house','street','metro','district','locality','area','province','country','hydro','railway','route','vegetation','cemetery','bridge','km','other') DEFAULT 'other',
  `precision` enum('exact','number','near','street','other','range') DEFAULT 'other',
  `logtime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`aid`),
  UNIQUE KEY `ClientID` (`ClientID`,`address`),
  KEY `ahash` (`ahash`),
  KEY `address` (`address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
