CREATE TABLE `bids_performance` (
  `perf_filter_id` bigint(20) unsigned NOT NULL,
  `pid` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `price_cpc` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `price_cpa` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `autobudgetPriority` tinyint(4) DEFAULT NULL,
  `target_funnel` enum('same_products','product_page_visit','new_auditory') NOT NULL,
  `condition_json` text NOT NULL,
  `now_optimizing_by` enum('CPC','CPA') NOT NULL DEFAULT 'CPC',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `statusBsSynced` enum('No','Sending','Yes') NOT NULL DEFAULT 'No',
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_suspended` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ret_cond_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`perf_filter_id`),
  KEY `statusBsSynced` (`statusBsSynced`),
  KEY `pid` (`pid`,`is_deleted`),
  KEY `LastChange` (`LastChange`),
  KEY `ret_cond_id` (`ret_cond_id`),
  CONSTRAINT `bids_performance_ibfk_1` FOREIGN KEY (`ret_cond_id`) REFERENCES `retargeting_conditions` (`ret_cond_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
