CREATE TABLE `campaigns` (
  `cid` int(10) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL,
  `ManagerUID` bigint(20) DEFAULT NULL,
  `AgencyUID` bigint(20) DEFAULT NULL,
  `name` text,
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `start_time` date NOT NULL DEFAULT '0000-00-00',
  `OrderID` bigint(20) NOT NULL DEFAULT '0',
  `AgencyID` int(10) NOT NULL DEFAULT '0',
  `currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN') NOT NULL,
  `sum_to_pay` decimal(16,6) NOT NULL,
  `sum` decimal(16,6) NOT NULL,
  `sum_spent` decimal(16,6) NOT NULL,
  `sum_last` decimal(16,6) NOT NULL,
  `sum_spent_units` bigint(20) NOT NULL,
  `sum_units` bigint(20) NOT NULL,
  `wallet_cid` int(10) unsigned NOT NULL DEFAULT '0',
  `statusModerate` enum('Yes','No','Sent','Ready','New','Mediaplan') DEFAULT 'New',
  `statusShow` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusActive` enum('Yes','No') NOT NULL DEFAULT 'No' COMMENT 'Real order status on BS frontend',
  `shows` int(10) DEFAULT NULL,
  `clicks` int(10) DEFAULT NULL,
  `statusEmpty` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusMail` int(10) DEFAULT '0',
  `archived` enum('Yes','No') NOT NULL DEFAULT 'No',
  `balance_tid` bigint(20) NOT NULL DEFAULT '0',
  `autobudget` enum('Yes','No') NOT NULL DEFAULT 'No',
  `autobudget_sum` double DEFAULT NULL,
  `autobudget_date` date NOT NULL,
  `statusBsSynced` enum('No','Yes','Sending') NOT NULL DEFAULT 'No',
  `statusNoPay` enum('No','Yes') NOT NULL DEFAULT 'No',
  `geo` text,
  `DontShow` text,
  `DoShow` text,
  `autoOptimization` enum('No','Yes') NOT NULL DEFAULT 'No',
  `dontShowCatalog` enum('No','Yes') NOT NULL DEFAULT 'No',
  `dontShowYacontext` enum('No','Yes') NOT NULL DEFAULT 'No',
  `autobudgetForecastDate` datetime DEFAULT NULL,
  `autobudgetForecast` double DEFAULT NULL,
  `autobudget_bid` double DEFAULT NULL,
  `autobudget_limit_clicks` int(10) DEFAULT NULL,
  `autobudget_avg_bid` double DEFAULT NULL,
  `autobudget_avg_cpa` double DEFAULT NULL,
  `autobudget_goal_id` bigint(20) unsigned DEFAULT NULL,
  `statusAutobudgetForecast` enum('New','Valid','Wrong') NOT NULL DEFAULT 'New',
  `timeTarget` text,
  `timezone_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lastShowTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusYacobotDeleted` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusBsArchived` enum('Yes','No') NOT NULL DEFAULT 'No',
  `statusOpenStat` enum('No','Yes') NOT NULL DEFAULT 'No',
  `disabledIps` text,
  `statusBehavior` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `type` enum('text','mcb','geo','market','wallet','mobile_content','performance','dynamic') NOT NULL DEFAULT 'text',
  `ProductID` int(10) DEFAULT NULL,
  `rf` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rfReset` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ContextLimit` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0 - auto, 254 - shows disabled, 255 - limiting disabled',
  `ContextPriceCoef` tinyint(3) unsigned NOT NULL DEFAULT '100',
  `strategy_min_price` set('min_price_guarantee','min_price_premium') NOT NULL DEFAULT '',
  `strategy_no_premium` enum('highest_place','min_price') DEFAULT NULL,
  `finish_time` date NOT NULL DEFAULT '0000-00-00',
  `day_budget` decimal(16,2) unsigned NOT NULL DEFAULT '0.00',
  `day_budget_show_mode` enum('default','stretched') NOT NULL DEFAULT 'default',
  `paid_by_certificate` enum('Yes','No') NOT NULL DEFAULT 'No',
  `currencyConverted` enum('Yes','No') NOT NULL DEFAULT 'No',
  `copiedFrom` int(10) unsigned NOT NULL DEFAULT '0',
  `opts` set('no_title_substitute','enable_cpc_hold','no_extended_geotargeting','has_probabilistic_auction','hide_permalink_info') NOT NULL DEFAULT '',
  `disabled_ssp` text,
  PRIMARY KEY (`cid`),
  KEY `i_uid` (`uid`),
  KEY `OrderID` (`OrderID`),
  KEY `ManagerUID` (`ManagerUID`),
  KEY `AgencyUID` (`AgencyUID`),
  KEY `idx_campaigns_sbs` (`statusBsSynced`),
  KEY `statusModerate` (`statusModerate`),
  KEY `LastChange` (`LastChange`),
  KEY `ClientID` (`ClientID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
