CREATE TABLE `clients` (
  `ClientID` int(10) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `work_currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN') DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_reps` text COMMENT 'old reps list for show and re-add in cmd_showClReps, cmd_showAgReps',
  `agency_url` varchar(255) DEFAULT NULL COMMENT 'from balance',
  `agency_status` enum('SA','AA','HY','WC','NR','ABU') DEFAULT NULL COMMENT 'DIRECT-1507, DIRECT-2618, DIRECT-6286',
  `primary_manager_uid` int(10) unsigned DEFAULT NULL,
  `primary_bayan_manager_uid` int(10) unsigned DEFAULT NULL,
  `primary_geo_manager_uid` int(20) unsigned DEFAULT NULL,
  `last_stopped_warn_mail` datetime DEFAULT NULL,
  `sum_on_stopped_camps` decimal(16,6) DEFAULT NULL,
  `allow_create_scamp_by_subclient` enum('No','Yes') NOT NULL DEFAULT 'No' COMMENT 'allow create self/servicing campaigns for subclients',
  `can_use_day_budget` enum('Yes','No') NOT NULL DEFAULT 'No',
  `country_region_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_favicon_blocked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `agency_allow_wallet` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ClientID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
