CREATE TABLE `clients_options` (
  `ClientID` int(10) unsigned NOT NULL,
  `balance_tid` bigint(20) unsigned NOT NULL,
  `overdraft_lim` decimal(10,2) NOT NULL,
  `debt` decimal(10,2) NOT NULL,
  `nextPayDate` date NOT NULL,
  `statusBalanceBanned` enum('Yes','No') DEFAULT 'No',
  `warned_nextPayDate` date DEFAULT NULL,
  `warned_interval` tinyint(4) DEFAULT NULL,
  `discount` decimal(4,2) DEFAULT NULL,
  `budget` decimal(24,2) DEFAULT NULL,
  `border_next` decimal(10,2) DEFAULT NULL,
  `discount_next` decimal(4,2) DEFAULT NULL,
  `border_prev` decimal(10,2) DEFAULT NULL,
  `hide_market_rating` tinyint(1) NOT NULL DEFAULT '0',
  `use_adgroups` tinyint(4) NOT NULL DEFAULT '0',
  `non_resident` tinyint(1) DEFAULT '0',
  `budget_currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN') DEFAULT NULL,
  `client_flags` set('no_text_autocorrection','no_display_hrefs','not_agreed_on_creatives_autogeneration','can_copy_ctr','not_convert_to_currency','auto_video') DEFAULT NULL,
  `subregion_id` int(10) unsigned DEFAULT NULL,
  `is_business_unit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ClientID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
