CREATE TABLE `currency_convert_queue` (
  `ClientID` int(10) unsigned NOT NULL,
  `uid` bigint(20) unsigned DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `convert_type` enum('COPY','MODIFY') NOT NULL,
  `state` enum('NEW','WAITING_TO_STOP','STOPPED','NOTIFY','DONE','CONVERTING_DETAILED_STAT','BS_NOTIFIED','BALANCE_NOTIFIED','FETCHING_BALANCE_DATA','OVERDRAFT_WAITING') NOT NULL DEFAULT 'NEW',
  `new_currency` enum('RUB','UAH','KZT','USD','EUR','TRY','CHF','BYN') NOT NULL,
  `country_region_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `start_convert_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `convert_started_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `convert_finished_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `success_page_accepted` tinyint(1) NOT NULL DEFAULT '0',
  `in_state_since` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `balance_convert_finished` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ClientID`),
  KEY `state` (`state`,`start_convert_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
