CREATE TABLE `mediaplan_stats` (
  `mpid` int(10) unsigned NOT NULL,
  `cid` int(10) unsigned NOT NULL,
  `ManagerUID` int(10) unsigned NOT NULL,
  `MediaUID` int(10) unsigned NOT NULL,
  `accepted` enum('Yes','No','Rejected') NOT NULL DEFAULT 'No',
  `accept_type` enum('merge','replace') DEFAULT 'merge',
  `accept_time` datetime DEFAULT NULL,
  `reject_reason` enum('too_expensive','bad_texts','bad_keywords','weird_intraface','have_questions','dont_need','do_myself','other') DEFAULT NULL,
  `requested` enum('Yes','No') NOT NULL DEFAULT 'No',
  `request_type` enum('keywords_text','keywords','text','optimize','optimize_wo_ext','optimize_ext') DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `mark` tinyint(3) unsigned DEFAULT NULL,
  `mark_time` datetime DEFAULT NULL,
  `comment` text,
  `AcceptUID` int(10) unsigned NOT NULL,
  `end_comment` text,
  `optimize_type` set('your_opinion','restore_disabled','improve_text','add_minus_words','specify_links','clear_disabled','add_rubrics','break_blocks') DEFAULT NULL,
  `difficulty_type` enum('lite','standard','max') DEFAULT NULL,
  `text_type` set('brand_name','illumination','template') DEFAULT NULL,
  `is_lego_mediaplan` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `num_banners_added` int(11) NOT NULL DEFAULT '0',
  `num_phrases_added` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mpid`),
  KEY `cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
