CREATE TABLE `mobile_content` (
  `mobile_content_id` bigint(20) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `store_content_id` varchar(200) NOT NULL,
  `store_country` char(2) NOT NULL,
  `os_type` enum('Android','iOS') NOT NULL,
  `content_type` enum('app','movie','book','music','newsstand','podcast') NOT NULL,
  `bundle_id` varchar(200) DEFAULT NULL,
  `is_available` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modify_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `store_refresh_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusBsSynced` enum('No','Sending','Yes') NOT NULL DEFAULT 'No',
  `name` varchar(255) DEFAULT NULL,
  `prices_json` varchar(4096) DEFAULT NULL,
  `rating` decimal(4,2) unsigned DEFAULT NULL,
  `rating_votes` int(10) DEFAULT NULL,
  `icon_hash` varchar(255) DEFAULT NULL,
  `statusIconModerate` enum('Yes','No','Sent','Sending','Ready') NOT NULL DEFAULT 'Ready',
  `min_os_version` varchar(10) DEFAULT NULL,
  `app_size_bytes` bigint(20) DEFAULT NULL,
  `available_actions` set('download','update','watch','read','play','listen','buy','rent') DEFAULT NULL,
  `publisher_domain_id` int(10) unsigned DEFAULT NULL,
  `genre` varchar(200) DEFAULT NULL,
  `age_label` enum('18+','16+','12+','6+','0+') DEFAULT NULL,
  `tries_count` int(10) DEFAULT '0',
  PRIMARY KEY (`mobile_content_id`),
  UNIQUE KEY `ClientID` (`ClientID`,`store_content_id`,`store_country`,`os_type`,`content_type`),
  KEY `statusIconModerate` (`statusIconModerate`),
  KEY `statusBsSynced` (`statusBsSynced`),
  KEY `modify_time` (`modify_time`),
  KEY `store_refresh_time` (`store_refresh_time`),
  KEY `_mobile_content_ibfk_1` (`publisher_domain_id`),
  CONSTRAINT `mobile_content_ibfk_1` FOREIGN KEY (`publisher_domain_id`) REFERENCES `domains` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
