CREATE TABLE `phrases` (
  `pid` bigint(20) NOT NULL,
  `adgroup_type` enum('base','dynamic','mobile_content','performance') NOT NULL DEFAULT 'base',
  `bid` bigint(20) DEFAULT NULL,
  `geo` text,
  `ContextID` int(10) unsigned NOT NULL DEFAULT '0',
  `PriorityID` int(10) unsigned NOT NULL DEFAULT '0',
  `statusModerate` enum('Yes','No','Sent','Sending','Ready','New') NOT NULL DEFAULT 'New',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statusBsSynced` enum('No','Yes','Sending') NOT NULL DEFAULT 'No',
  `statusAutobudgetShow` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusShowsForecast` enum('New','Processed','Sending','Archived') NOT NULL DEFAULT 'New',
  `forecastDate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusPostModerate` enum('New','Yes','No','Ready','Sent','Rejected') NOT NULL DEFAULT 'No',
  `mw_id` int(10) unsigned DEFAULT NULL,
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `group_name` text,
  `is_bs_rarely_loaded` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `i_bid` (`bid`),
  KEY `LastChange` (`LastChange`),
  KEY `idx_phrases_sbs` (`statusBsSynced`),
  KEY `statusPostModerate` (`statusPostModerate`),
  KEY `statusModerate` (`statusModerate`),
  KEY `statusShowsForecast` (`statusShowsForecast`,`forecastDate`),
  KEY `p_cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
