CREATE TABLE `stat_reports` (
  `id` int(10) unsigned NOT NULL,
  `report_type` enum('stat_mp','client_potential') NOT NULL DEFAULT 'stat_mp',
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `cids` text NOT NULL,
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `operator_uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `status` enum('new','processing','failed','ready') NOT NULL DEFAULT 'new',
  `extra_opt_compressed` longblob,
  `report_stats` text NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ready_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `report_data_format` enum('csv','xls','xlsx') NOT NULL DEFAULT 'csv',
  `report_data_parts_qty` smallint(6) NOT NULL DEFAULT '0',
  `process_attempts` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `ready_time` (`ready_time`),
  KEY `create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
