CREATE TABLE `users` (
  `uid` bigint(20) NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '',
  `valid` tinyint(8) DEFAULT '2',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `FIO` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) DEFAULT NULL,
  `sendNews` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `sendWarn` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `createtime` bigint(20) DEFAULT NULL,
  `ClientID` int(10) NOT NULL DEFAULT '0',
  `login` varchar(255) DEFAULT NULL,
  `hidden` enum('Yes','No') NOT NULL DEFAULT 'No',
  `sendAccNews` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `not_resident` enum('No','Yes') NOT NULL DEFAULT 'No',
  `statusArch` enum('Yes','No') DEFAULT 'No',
  `statusBlocked` enum('Yes','No') DEFAULT 'No',
  `description` text,
  `lang` char(2) NOT NULL DEFAULT 'ru',
  `captcha_freq` int(11) NOT NULL DEFAULT '0',
  `allowed_ips` mediumtext,
  `statusYandexAdv` enum('Yes','No') NOT NULL DEFAULT 'No' COMMENT 'User can create only yandex advertising, which shows only on context pages',
  `showOnYandexOnly` enum('Yes','No') NOT NULL DEFAULT 'No' COMMENT 'User can create only yandex advertising, which shows only on Yandex pages',
  PRIMARY KEY (`uid`),
  KEY `idx_users_login` (`login`),
  KEY `ClientID` (`ClientID`),
  KEY `users_createtime_index` (`createtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 
