CREATE TABLE `users_api_options` (
  `uid` bigint(20) unsigned NOT NULL,
  `api_enabled` enum('Yes','No','Default') NOT NULL DEFAULT 'Default',
  `api_offer` enum('accepted','rejected') NOT NULL DEFAULT 'rejected',
  `api_units_factor` double DEFAULT '1',
  `advq_queries_lim` int(11) DEFAULT NULL COMMENT 'Number of single advq queries which are allowed to user daily',
  `allow_create_subclients` enum('Yes','No') DEFAULT 'No' COMMENT 'Allow to create new users through API for agencies and managers',
  `api_allowed_ips` varchar(255) DEFAULT NULL,
  `api_geo_allowed` enum('Yes','No') DEFAULT 'No' COMMENT 'Allow to work with geocontext campaigns',
  `api_allow_old_versions` enum('Yes','No') NOT NULL DEFAULT 'No',
  `api_allow_finance_operations` enum('Yes','No') DEFAULT 'No',
  `api_developer_name` text,
  `api_developer_email` text,
  `api_send_mail_notifications` enum('Yes','No') DEFAULT 'Yes',
  `api_units_daily` int(11) DEFAULT NULL,
  `upload_adgroup_xls` enum('Yes','No') NOT NULL DEFAULT 'No',
  `excel_rows_limit` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
