CREATE TABLE `wallet_payment_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wallet_cid` int(10) unsigned NOT NULL,
  `payer_uid` bigint(20) unsigned NOT NULL,
  `trust_payment_id` char(24) NOT NULL,
  `status` enum('Processing','Done','Error') NOT NULL DEFAULT 'Processing',
  `balance_status` varchar(32) NOT NULL DEFAULT '',
  `balance_status_code` varchar(32) NOT NULL DEFAULT '',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` enum('auto') NOT NULL DEFAULT 'auto',
  `total_balance_tid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `params` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trust_payment_id` (`trust_payment_id`),
  KEY `wallet_cid` (`wallet_cid`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
