#!/usr/bin/perl

=head1 TEST

    $Id:$

=cut

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Data::Dumper;
use Test::Deep;
use YAML;

use FindBin qw/$Bin/;
use lib "$Bin/../../lib";
use Direct::Homemade::SqlParser;

use utf8;

for my $file(glob "$Bin/parse_statements-data/correct-alter*.sql"){
    my $file_ast = $file=~ s/\.sql/.ast.yaml/r;

    open(my $fh, '<', $file) or die "can't open file '$file': $!; stop\n";
    my $statement = join "", <$fh>;
    my $ast = parse_alter_table_statement($statement);
    if ( !-e $file_ast ){
        print STDERR "$file_ast\n";
        print STDERR YAML::Dump($ast);
        print STDERR "$file_ast\n";
    }
    my $true_ast = YAML::LoadFile($file_ast);
    cmp_deeply($ast, $true_ast, "statement and ast from files $file, $file_ast");
}

for my $file(glob "$Bin/parse_statements-data/correct-create-table*.sql"){
    my $file_ast = $file=~ s/\.sql/.ast.yaml/r;

    open(my $fh, '<', $file) or die "can't open file '$file': $!; stop\n";
    my $statement = join "", <$fh>;
    my $ast = parse_create_table_statement($statement);
    if (! -e $file_ast ){
        print STDERR "$file_ast\n";
        print STDERR YAML::Dump($ast);
        print STDERR "$file_ast\n";
        # для быстрого заполнения больших тестовых данных
        #open(my $fh_ast, '>', $file_ast) or die "can't open file '$file': $!; stop\n";
        #print $fh_ast YAML::Dump($ast);
    }
    my $true_ast = YAML::LoadFile($file_ast);
    cmp_deeply($ast, $true_ast, "statement and ast from files $file, $file_ast");
}


done_testing();

