#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ":std" => ":encoding(UTF-8)";

use Test::More;
use Test::Exception;
use Data::Dumper;
use Getopt::Long qw(:config no_ignore_case);
use POSIX qw(strftime);
use YAML qw(DumpFile LoadFile);
use Path::Tiny;
use File::Compare;
use FindBin qw/$Bin/;

use Yandex::DBTools;
use Yandex::DBShards;

my $dbs_bin = "$Bin/../bin/dbs";

my $conf_file = "$Bin/dbs_cfg.yaml";
my $conf;

my $regex = "'s/dbs-[a-zA-Z_-]*[0-9-]+/SESSION_NAME/g'";
my $regex1 = "";

if ($ENV{MY_CFG}) {
    $conf_file = $ENV{MY_CFG};
}

$conf = YAML::LoadFile($conf_file);
$ENV{TMPDIR} = $conf->{tmp_path};
my $trust_file = "$Bin/$conf->{trust_file}";
my $new_file = "$Bin/$conf->{new_file}";

my $file1 = Path::Tiny->tempfile("test_dbs1_XXXXXXXX", UNLINK => 0);
system("sed -r -e $regex -e 's/SESSION_NAME:[^:]*:/SESSION_NAME:USER_NAME:/g' $trust_file > $file1");

ok(system("$Bin/dbs-good-params.sh $dbs_bin > $new_file") == 0, 'Запуск тестирующего скрипта');

my $file2 = Path::Tiny->tempfile("test_dbs2_XXXXXXXX", UNLINK => 0);
my $whoami = [getpwuid($<)]->[0];
system("sed -r -e $regex -e 's/SESSION_NAME:$whoami/SESSION_NAME:USER_NAME/g' $new_file > $file2");

system("sed -i -e 's/MYSQL_PWD=[^ ]*/MYSQL_PWD=***/g' $file1 $file2");
system("sed -i -e 's/host=[^ ]*/host=hostname/g' $file1 $file2");
system("sed -i -e 's/-h [^ ]*/-h hostname/g' $file1 $file2");
system("sed -i -e 's/-H [^ ]*/-H hostname/g' $file1 $file2");
system("sed -i -e 's/3[^ ]*Gf/***/g' $file2");

ok(compare($file1,$file2) == 0, "Сравнение полученного файла и эталонного ($file1, $file2)");
    
done_testing();
