#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ":std" => ":encoding(UTF-8)";

use Test::More;
use Test::Exception;
use Data::Dumper;
use Getopt::Long qw(:config no_ignore_case);
use POSIX qw(strftime);
use YAML qw(DumpFile LoadFile);
use Path::Tiny;

use FindBin qw/$Bin/;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::DBUnitTest qw/:all/;

my $conf;
my $conf_path = "$Bin/../bin";

sub check_kill_comment
{
    my $file1 = Path::Tiny->tempfile("test_guard1_XXXXXXXX", UNLINK => 0);
    my $file2 = Path::Tiny->tempfile("test_guard1_XXXXXXXX", UNLINK => 0);
    
    print "1. Проверка специального комментария: /* dbs-guard-kill-me */\n";
    
    my $host = "$conf->{host}";
    my $port = $conf->{port};
    my $user = "$conf->{user}";
    my $pass = "$conf->{pass}";
    my $db = "$conf->{db}";
    
    my $pid1= `timeout 30 $conf_path/direct-query-guard -H $host -P $port -u $user -p $pass --db $db > $file1 2>&1 & echo \$!`;
    
    print "Немного ждем...\n";
    sleep 6;
    
    if (kill(0, $pid1) == 0) {
        BAIL_OUT("direct-query-guard не запущен, вывод в файле '$file1'");
    }
    
    print "Делаем запрос 'SELECT /* dbs-guard-kill-me */ SLEEP(3);'\n";
    my $exit_code = eval{system("mysql -u $user -p$pass --port $port -h $host --comments --database $db -e 'SELECT /* dbs-guard-kill-me */ SLEEP(3);' > $file2 2>&1")};
    
    my $res1 = kill 'TERM', $pid1;
    
    ok($exit_code != 0, "Проверяем, удаляется ли запрос с комментарием");
}

sub check_copy
{
    my $file1 = Path::Tiny->tempfile("test_guard2_XXXXXXXX", UNLINK => 0);
    my $file2 = Path::Tiny->tempfile("test_guard2_XXXXXXXX", UNLINK => 0);
    my $file3 = Path::Tiny->tempfile("test_guard2_XXXXXXXX", UNLINK => 0);
    
    my $host = "$conf->{host}";
    my $port = $conf->{port};
    my $user = "$conf->{user}";
    my $pass = "$conf->{pass}";
    my $db = "$conf->{db}";
    
    print "\n2. Проверка на  повторный запуск.\nЗапускаем 3 раза подряд guard\n";
    print "1....\n";
    
    my $pid1= `timeout 30 $conf_path/direct-query-guard -H $host -P $port -u $user -p $pass --db $db > $file1 2>&1 & echo \$!`;
    
    sleep 5;
    
    if (kill(0, $pid1) == 0) {
        BAIL_OUT("direct-query-guard не запущен, вывод в файле '$file1'");
    }
    
    print "2....\n";
    
    my $pid2 = `timeout 30 $conf_path/direct-query-guard -H $host -P $port -u $user -p $pass --db $db > $file2 2>&1 & echo \$!`;
    
    sleep 5;
    
    print "3....\n";
    
    my $pid3 = `timeout 30 $conf_path/direct-query-guard -H $host -P $port -u $user -p $pass --db $db > $file3 2>&1 & echo \$!`;
    
    print "Запустили. Ждем 5 секунд...\n";
    
    sleep 5;
    
    my $res3 = kill 'TERM', $pid3;
    my $res2 = kill 'TERM', $pid2;
    my $res1 = kill 'TERM', $pid1;
    
    ok($res3==0 && $res2==0 && $res1==1, "Проверка на повторный запуск.");
    
}

sub check_priv
{  
    print "\n";
    print "3. Проверка привилегий пользователя guard'а.\n";
    print "Используем заранее созданных юзеров.\n";
    
    my $file1 = Path::Tiny->tempfile("test_guard3_XXXXXXXX", UNLINK => 0);
    ok(check_cur_priv("$conf->{user}", "$conf->{pass}", "ALL PRIVILEGES", $file1) != 0, "Проверка привилегий: ALL PRIVILEGES");
    
    #my $file2= Path::Tiny->tempfile("test_guard3_XXXXXXXX", UNLINK => 0);
    #ok(check_cur_priv("test_super1", "password", "SUPER", $file2) != 0, "Проверка привилегий: SUPER");
    
    #my $file3= Path::Tiny->tempfile("test_guard3_XXXXXXXX", UNLINK => 0);
    #if (ok(check_cur_priv("test_select", "abcd", "SELECT",$file3) == 0, "Проверка привилегий: SELECT")) {
    #    ok(open(my $fh, '<:encoding(UTF-8)', $file3), "Ищем tmp файл");
    #    my $row = <$fh>;
    #    chomp $row;
    #    ok($row =~ /error: нет нужных привилегий у текущего пользователя/, "Проверка вывода ошибки guard'ом");
    #}
    print "\n";
}

sub check_cur_priv
{
    (my $user, my $pass, my $priv, my $file1) = @_;
    
    print "\n$user - $priv:\n";
    print "Ждем 10 секунд...\n";
    
    my $host = $conf->{host};
    my $port = $conf->{port};
    my $db = $conf->{db};
    
    my $pid1= `timeout 30 $conf_path/direct-query-guard -H $host -P $port -u $user -p $pass --db $db > $file1 2>&1 & echo \$!`;
    
    sleep 10;
    
    my $res1 = kill 'TERM', $pid1;
    
    return ($res1 == 1);
}

$conf = {
          "host" => $Yandex::DBTools::DB_CONFIG{host},
          "port" => $Yandex::DBTools::DB_CONFIG{port},
          "pass" => $Yandex::DBTools::DB_CONFIG{pass},
          "user" => $Yandex::DBTools::DB_CONFIG{user},
          "tmp_path" => "/tmp/temp-ttl/ttl_1d/",
          "db" => $Yandex::DBTools::DB_CONFIG{CHILDS}{unit_tests}{db},
        };

print "Изначально guard должен быть выключен!\n\n";

$ENV{TMPDIR} = $conf->{tmp_path};

subtest "Проверка уничтожения запросов с комментарием /* dbs-guard-kill-me */", \&check_kill_comment;

subtest "Проверка на повторный запуск", \&check_copy;
    
subtest "Проверка привилегий", \&check_priv;
    
done_testing();
