#!/usr/bin/perl

=head1 TEST


    $Id:$

=cut

use utf8;
use open ":std" => ":encoding(UTF-8)";

use strict;
use warnings;

use Test::More;
use Test::Exception;
use Data::Dumper;

use FindBin qw/$Bin/;

my $direct_pt_osc_bin = "$Bin/../bin/direct-pt-osc";

my @TEST_CASES = (
    {
        name => 'test 1',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;'",
        expected => q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0   --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 240 --check-interval 1 --execute; echo $?; date
!,
    },
    {
        name => 'test 2',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;' --no-auto-finish",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0 --no-swap-tables --no-drop-new-table --no-drop-triggers  --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 240 --check-interval 1 --execute; echo $?; date
!,
    },
    {
        name => 'test 3',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;' --no-auto-finish --osc-dry-run",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0 --no-swap-tables --no-drop-new-table --no-drop-triggers  --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 240 --check-interval 1 --dry-run; echo $?; date
!,
    },
    {
        name => 'test 4',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;' --no-auto-finish --no-check-alter",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0 --no-swap-tables --no-drop-new-table --no-drop-triggers --no-check-alter --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 240 --check-interval 1 --execute; echo $?; date
!,
    },
    {
        name => 'test 5',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;' --max-lag 301 --check_interval 2",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0   --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 301 --check-interval 2 --execute; echo $?; date
!,
    },
    {
        name => 'test 6',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;' --recursion-method none",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1000 --max-load Threads_running=100 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0   --recurse 1 --recursion-method none --nocheck-replication-filters --max-lag 240 --check-interval 1 --execute; echo $?; date
!,
    },
    {
        name => 'test 7',
        params => "-h ppctest-mysql04i.yandex.ru --port 3352 -u adiuser -p utro --db ppc 'ALTER TABLE camp_options FORCE;'  --critical-load Threads_running=1001 --max-load Threads_running=101",
        expected =>  q!set -ex
date; pt-online-schema-change t=camp_options,h=ppctest-mysql04i.yandex.ru,P=3352,u=adiuser,p=***,D=ppc --alter 'FORCE' --critical-load Threads_running=1001 --max-load Threads_running=101 --alter-foreign-keys-method rebuild_constraints --set-vars foreign_key_checks=0   --recurse 1 --recursion-method hosts --nocheck-replication-filters --max-lag 240 --check-interval 1 --execute; echo $?; date
!,
    },
);

for my $tc (@TEST_CASES){
    my $cmd = "$direct_pt_osc_bin $tc->{params} 2>/dev/null | grep -v '^#' |grep -v '^ *\$'";
    my $output = `$cmd`;
    print "$tc->{params}\n";
    is($output, $tc->{expected}, $tc->{name});
    print "\n";
}

done_testing();

