# -*- coding: utf-8 -*-

from app import app, render_template, request, jsonify, url_for
from startrek_client import Startrek
import json
import os

items_per_page = 500
max_items = 1000
items_per_page_show = 200

st_token = os.environ.get('DIRECT_PPC_STARTREK_TOKEN', '')

if st_token == '':
    exit(1)

@app.route('/filters/')
def index():
    return u'Hello, World! Write "/filters/do" for start!'


@app.route('/filters/do/')
@app.route('/filters/do/<path:params>')
def complete_events(params=''):
    client = Startrek(useragent=u'direct-tag-cloud',
                      token=st_token)
    ticket_names = []
    components = []
    tags = []
    queues = []
    types = []
    assignees = []
    statuses = []
    try:
        query = request.args.get('query') or ''
        filters = request.args.get('filters') or ''

        try:
            issues = list([])
            page = 0
            if query != '':
                while len(issues) < max_items:
                    page += 1
                    new_issues = client.issues.find(query, per_page=items_per_page, page=page)
                    if isinstance(new_issues,list):
                        issues.extend(new_issues)
                        break
                    else:
                        issues.extend(new_issues._data)
        except Exception,e:
            issues = []
            print e

        for x in issues:
            try:
                new_el = {}
                new_el["key"] = x.key
                new_el["summary"] = x.summary
                if x.assignee != None:
                    new_el["assignees"] = x.assignee.display
                else:
                    new_el["assignees"] = u'Не назначен'
                assignees.append(new_el["assignees"])
                new_el["components"] = [j.name for j in x.components]
                components.extend(new_el["components"])
                new_el["tags"] = x.tags
                new_el["types"] = x.type.name
                new_el["queues"] = x.queue.key
                new_el["statuses"] = x.status.name
                tags.extend(x.tags)
                queues.append(x.queue.key)
                types.append(x.type.name)
                ticket_names.append(new_el)
                statuses.append(x.status.name)
            except Exception, e:
                print e
    except Exception,e:
        print e

    components = count(components)
    tags = count(tags)
    queues = count(queues)
    types = count(types)
    statuses = count(statuses)
    assignees = count(assignees)
    print url_for('static', filename='style.css')

    return render_template('tag_cloud.html',
                           tickets=json.dumps(ticket_names),
                           components=json.dumps(components),
                           tags=json.dumps(tags),
                           queues=json.dumps(queues),
                           types=json.dumps(types),
                           assignees=json.dumps(assignees),
                           statuses=json.dumps(statuses),
                           query=query,
                           filters=filters,
                           )


def count(ls):
    if not ls:
        return []
    ls.sort()
    new_ls = []
    new_ls.append({"name": ls[0], "quantity" : 0})
    for elem in ls:
        if (new_ls[-1]['name'] == elem):
            new_ls[-1]['quantity'] += 1
        else:
            new_ls.append({"name": elem, "quantity" : 1})
    new_ls.sort(key=lambda x: x['quantity'], reverse=True)
    return new_ls
