# -*- coding: utf-8 -*-

from app import app, render_template, request, jsonify
from startrek_client import Startrek
import json
import os


tree_summary_length = 40
force_summary_length = 15
ready_issue_types = {'1', '2', '3', '4', '7', '11', '12', '49', '53', '63', '71', '113', '111'}
link_types = {"depends": 1, "subtask": 2, "relates": 3, "duplicates": 4, "cloners": 5}

st_token = os.environ.get('DIRECT_PPC_STARTREK_TOKEN', '')

if st_token == '':
    exit(1)

@app.route('/')
@app.route('/index')
def index():
    return u'Hello, World! Write "/do" for start!'


@app.route('/do/')
@app.route('/do/<path:params>')
def complete_events(params=''):
    if (request.args.get('graph') == 'force'):
        graph = 'force'
        template_name = 'graph_force.html'
        ticket_names = get_links_force()
    else:
        graph = 'tree'
        template_name = 'graph_tree.html'
        ticket_names = get_links_tree()

    return render_template(template_name,
                           main_ticket=request.args.get('ticket') or '',
                           graph=graph,
                           tickets=json.dumps(ticket_names),
                           )


@app.route('/get_neighbours_json/')
@app.route('/get_neighbours_json/<path:params>')
def get_json_neighbours(params=''):
    if (request.args.get('graph') == 'force'):
        ticket_names = get_links_force()
    else:
        ticket_names = get_links_tree()
    return jsonify(tickets=ticket_names)


def get_links_tree():
    client = Startrek(useragent=u'direct-direct-tracker-viewer',
                      token=st_token)
    if request.args.get('ticket') == None or request.args.get('ticket') == '':
        return {}
    try:
        issue = client.issues[request.args.get('ticket') or '']

        links = issue.links.get_all()

        ticket_names = {}
        ticket_names['name'] = issue.key
        ticket_names['issuetype'] = issue.type.id
        ticket_names['linktype'] = 0
        ticket_names['summary'] = issue.summary[:tree_summary_length]
        if (ticket_names['summary'] != issue.summary):
            ticket_names['summary'] += '...'
        ticket_names["summary"] += ' |' + str(links.__len__())

        ticket_names['children'] = []
        for x in links:
            try:
                new_el = {}
                new_el["name"] = x.object.key
                new_el["issuetype"] = x.object.type.id
                if not (new_el["issuetype"] in ready_issue_types):
                    new_el['issuetype'] = "404"
                new_el["linktype"] = link_types[x.type.id]
                new_el["summary"] = x.object.summary[:tree_summary_length]
                kol = x.object.links.get_all().__len__()
                if (new_el["summary"] != x.object.summary):
                    new_el["summary"] += '...'
                new_el["summary"] += ' |' + str(kol - 1)
                ticket_names['children'].append(new_el)
            except Exception,e:
                print e
        return ticket_names
    except:
        return {}


def get_links_force():
    client = Startrek(useragent=u'direct-direct-tracker-viewer',
                      token=st_token)
    if request.args.get('ticket') == None or request.args.get('ticket') == '':
        return []

    try:
        issue = client.issues[request.args.get('ticket') or '']
        links = issue.links.get_all()

        ticket_names = []
        new_el = {}
        new_el['label'] = issue.key
        new_el['issuetype'] = issue.type.id
        new_el['linktype'] = 0
        new_el['summary'] = issue.summary[:force_summary_length]
        if (new_el['summary'] != issue.summary):
            new_el['summary'] += '...'
        new_el['summary'] += ' |' + str(links.__len__())

        ticket_names.append(new_el)
        for x in links:
            try:
                new_el = {}
                new_el["label"] = x.object.key
                new_el["issuetype"] = x.object.type.id
                if not (new_el["issuetype"] in ready_issue_types):
                    new_el['issuetype'] = "404"
                new_el["linktype"] = link_types[x.type.id]
                new_el["summary"] = x.object.summary[:force_summary_length]
                kol = x.object.links.get_all().__len__()
                if (new_el["summary"] != x.object.summary):
                    new_el["summary"] += '...'
                new_el["summary"] += ' |' + str(kol - 1)
                ticket_names.append(new_el)
            except Exception,e:
                print e
        return ticket_names
    except:
        return []
