#!/bin/bash -e 

SECRET=`./bin/dt-yav cat sec-01crxmhw63b6rx0jykndkre158:ssh-rsa-private`
DST_FILE='/etc/direct-tokens/ssh-rsa_robot-direct-yav-p'

if [ -z "$1" ]
then
    echo "expecting hostname, stop"
    exit 1
fi

if [ -z "$SECRET" ]
then
    echo "empty secret, stop"
    exit 2
fi

ssh -q root@$1 /bin/bash <<EOF
if [ -e "$DST_FILE" ] 
then
    echo "file $DST_FILE already exists, stop"
    exit 3
fi
if [ ! -d "$(dirname ${DST_FILE})" ]
then 
    echo "Creating directory: $(dirname ${DST_FILE})"
    mkdir -p "$(dirname ${DST_FILE})"
fi
touch $DST_FILE
chmod 600 $DST_FILE
echo "$SECRET" > "$DST_FILE"
chmod 400 $DST_FILE
ls -l $DST_FILE
EOF

echo DONE

