#!/usr/bin/python
# -*- coding: utf8 -*-

import unittest
import subprocess
import os
import glob
import shutil
import json
import stat


class TestDirectVault(unittest.TestCase):
    def test_zipunzip(self):
        bin_dir = os.path.abspath(os.path.dirname(__file__))
        test_dir = '%s/for_test' % bin_dir
        os.mkdir(test_dir)
        script_dir = '%s/../bin/' % bin_dir
        subprocess.call(['%sdirect-vault' % script_dir, 'init', '-p', "pass:abcd", '-d', test_dir])
        subprocess.call(['echo "test zip unzip" | %sdirect-vault -p "pass:abcd" tee file1 -d %s' % (script_dir, test_dir)], shell=True)
        self.assertEqual(subprocess.check_output('%sdirect-vault -d %s -p "pass:abcd" cat file1' % (script_dir, test_dir), shell=True).strip(), "test zip unzip")
        shutil.rmtree(test_dir)
    
    def test_place_secrets(self):
        bin_dir = os.path.abspath(os.path.dirname(__file__))
        test_dir = '%s/for_test' % bin_dir
        os.mkdir(test_dir)
        script_dir = '%s/../bin/' % bin_dir
        subprocess.call(['%sdirect-vault' % script_dir, 'init', '-p', "pass:abcd", '-d', test_dir])
        subprocess.call(['echo "test direct place secrets" | %sdirect-vault -p "pass:abcd" tee file1 -d %s' % (script_dir, test_dir)], shell=True)
        subprocess.call(['echo "test direct place secrets 2" | %sdirect-vault -p "pass:abcd" tee file2 -d %s' % (script_dir, test_dir)], shell=True)
        subprocess.call(['%sdirect-vault -d %s --pass "pass:abcd" export ./exported' % (script_dir, test_dir)], shell=True)
        subprocess.call(['%sdirect-place-secrets -d %s/exported -m %s/test_manifest.json' % (script_dir, test_dir, bin_dir)], shell=True)

        manifest = json.load(open('%s/test_manifest.json' % bin_dir, 'r'))

        for directory in manifest['dirs']:
            self.assertTrue(os.path.exists(directory['dst']) and os.path.isdir(directory['dst']))
       
        for f in manifest['files']:
            self.assertTrue(os.path.exists(f['dst']) and os.path.isfile(f['dst']))
            if 'mode' in f and os.path.exists(f['dst']):
                self.assertEqual(str(oct(stat.S_IMODE(os.stat(f['dst']).st_mode))), f['mode'])
            
        shutil.rmtree(test_dir)
        shutil.rmtree(manifest['dirs'][0]['dst'])
        


if __name__ == '__main__':
    unittest.main()

