#!/usr/bin/python

import re
import ConfigParser
from time import time, mktime, strptime

from tac import tac_rotated

config = ConfigParser.RawConfigParser()
config.read("/home/monitor/agents/etc/access-log-errors.conf")

log_path = config.get('Default', 'log_path')
period = 300
period_border = time() - period
critical = 1
warning = 0.5


def older_than_period(t):
    global period_border
    try:
        line_time = strptime(t.split()[0], '%d/%b/%Y:%H:%M:%S')
    except ValueError:
        return False
    else:
        return mktime(line_time) < period_border


re_line = re.compile(r'.+? \[(?P<time>.+?) .+?\] ".+?" (?P<status>\d{3}) ".+?" "(?P<UA>.+?)"')
errors = 0
count = 0
for line in tac_rotated(log_path):
    m = re_line.match(line)
    if m:
        line_time = m.group('time')
        if older_than_period(line_time):
            break
        line_ua = m.group('UA').lower()
        if line_ua.find('nagios') == -1 and line_ua.find('keepaliveclient') == -1:
            line_status = m.group('status')
            if str(line_status)[0] == '5':
                errors += 1
            count += 1

if count == 0:
    ratio = None
else:
    ratio = float(errors) / count * 100

if ratio == None:
    status = 1
    message = 'No responses in last %d seconds' % period
elif ratio > critical:
    status = 2
    message = '%.2f%% responses with 5xx status code' % ratio
elif ratio > warning:
    status = 1
    message = '%.2f%% responses with 5xx status code' % ratio
else:
    status = 0
    message = 'OK'

print 'PASSIVE-CHECK:access-log-errors;%d;%s' % (status, message)
