#!/bin/bash
CH_CLIENT=/usr/bin/clickhouse-client
tmpFile=$(mktemp)

CH_RO=`$CH_CLIENT -q 'SELECT database, table, is_leader, is_readonly, is_session_expired, future_parts, parts_to_check, columns_version, queue_size, inserts_in_queue, merges_in_queue FROM system.replicas WHERE is_readonly OR is_session_expired;' 2> $tmpFile | awk '{print $2}' | perl -pe 's/\n/ /g'`
CH_OTHER=`$CH_CLIENT -q 'SELECT database, table, future_parts, parts_to_check, columns_version, queue_size, inserts_in_queue, merges_in_queue FROM system.replicas WHERE future_parts > 25 OR parts_to_check > 10  OR queue_size > 50 OR inserts_in_queue > 25;' 2> $tmpFile | awk '{print $2}' | perl -pe 's/\n/ /g'`

mon_type=$1

ERROR=$(<$tmpFile)
[ -e $tmpFile ] && rm $tmpFile

[ -z "$ERROR" ] || echo "2;Clickhouse dont working: $ERROR"
[ -z "$ERROR" ] || exit 1
  
case $mon_type in
"ro")
  [ -z "$CH_RO" ] && echo "0;OK" || echo "2;Clickhouse readonly: $CH_RO"
;;
"repl")
  [ -z "$CH_OTHER" ] && echo "0;OK" || echo "2;Clickhouse replication failed: $CH_OTHER"
;;
esac
