#!/bin/bash
clickhouse-client -q 'select table, round(sum(data_compressed_bytes), 2) as data_compressed_bytes from system.columns where data_uncompressed_bytes > 0 group by table order by data_compressed_bytes, table;' | perl -lane 'BEGIN { $host = qx(hostname -f); chomp $host; $host =~ s/[^0-9a-zA-Z-]/_/g; $ts = time; } if (defined($F[0]) && defined($F[1])) { print "one_min.$host.ClickHouse.compressed_bytes.table.$F[0] $F[1] $ts"; $total += $F[1] } END { print "one_min.$host.ClickHouse.compressed_bytes.total $total $ts"; }'
