#!/usr/bin/env python
# *-* encoding: utf8 *-*

from __future__ import print_function
from kazoo.client import KazooClient
from kazoo.client import KazooState
from optparse import OptionParser

import re
import sys

ZK_SERVERS = 'zxzk01f.yandex.ru:2181,zxzk01e.yandex.ru:2181,zxzk01i.yandex.ru:2181'
#ZK_PATH = '/pi-clickhouse/tables'

def listener(state):
    if state == KazooState.LOST:
        print('connection zookeeper closed', file=sys.stderr)
    elif state == KazooState.SUSPENDED:
        print('connection zookeeper suspend', file=sys.stderr)
    else:
        pass

def run(servers, zkhome, autofix=False, debug=False):
    rgxp = re.compile('.*\ntable:\s+(\S+)\n.*')
    error = 0
    
    if not zkhome:
        print('zkhome is empty. Fix it. Exit.', file=sys.stderr)
        sys.exit(1)

    zk = KazooClient(hosts=servers, read_only=False)
    if debug: zk.add_listener(listener)

    zk.start()

    shards = zk.get_children(zkhome)
    for sh1 in shards:
        head = [zkhome,sh1]
        tables = zk.get_children('/'.join(head))
        for tb2 in tables:
             path = head[:]
             path.append(tb2)
             path.append('replicas')
             hosts = zk.get_children('/'.join(path))
             for ht3 in hosts:
                 node = path[:]
                 node.append(ht3)
                 node.append('host')
                 data = zk.get('/'.join(node))
                 tb_name = rgxp.findall(data[0])[0]

                 if tb_name != tb2 and error == 0:
                     print('BUG!! CLICKHOUSE-3658. Need rename table name in clickhouse node zookeeper.')
                     error += 1
                 if tb_name != tb2:
                     print('{0}: {1}'.format('/'.join(node), tb_name))
                     ask = 'y' if autofix else str(raw_input('fix it? [y/N]'))
                     if ask.lower() == 'y':
                         fxdata = data[0].replace(tb_name, tb2)
                         zk.set(path='/'.join(node), value=str(fxdata))
    if error == 0:
        print('not found corrupt nodes clickhouse in zookeeper')
    zk.stop()
    

if __name__ == '__main__':
    USAGE = "usage: %prog"
    VERSION = "1.0.0"

    parser = OptionParser(usage=USAGE, version=VERSION)
    parser.add_option( "-y", "--auto-fix",
                       action="store_true", dest="autofix",
                       help="Automatic fix clickhouse nodes in Zookeeper." )
    parser.add_option( "-d", "--debug",
                       action="store_true", dest="debug",
                       help="debug mode" )
    parser.add_option( "-p", "--home",
                       action="store", dest="zkhome", default=None, 
                       help="home path directory for start search nodes. Example: /pi-clickhouse/tables" )
    parser.add_option( "-s", "--servers",
                       action="store", dest="zkservers",
                       default=ZK_SERVERS, help="zookepeer servers for connect. Example: zxzk01f.yandex.ru:2181" )
    (opts, args) = parser.parse_args()

    run(opts.zkservers, opts.zkhome, opts.autofix)
