#!/usr/bin/perl

my @fails, @success; 
my $cmd;

if (! -e '/usr/bin/vtysh') { print "0; Not found quagga pkg"; exit }
    
$cmd = '/usr/bin/vtysh -e "sh ip bgp neighbors"';
my $result = qx($cmd 2>&1); 
my $rc = $?; 

if( $rc != 0 ) { print "2; $result"; exit }; 

while ( $result =~ /BGP\sneighbor\sis\s(.+?),+\sremote\sAS\s(.+?),+\slocal\sAS\s(.+?),+\sinternal\slink\n\s\sBGP\sversion\s(.+?),+\sremote\srouter\sID\s(.+?)\n\s\sBGP\sstate\s=\s(.+?)[,]?\s/g) { 
      my $ip=$1, $status=$6; 
      $status =~ /Established/ ?  push @success, $ip . "/" . $status : (push @fails, $ip . "/" . $status) 
    }; 

scalar @fails > 0 ? print "1; @fails\n" : print "0; @success\n"
