#-*- coding: utf-8 -*-
import os
import re
import json
import sys
import locale
import codecs
import Cookie
import calendar
import datetime
import urllib2
import memcache

from jinja2 import Environment, FileSystemLoader, ChoiceLoader

reload(sys)
sys.setdefaultencoding('utf-8')

FORWARD_ADMIN_NUMBER  = '3339'
FORWARD_DEV_NUMBER  = '2270'
FORWARD_API     = "http://bot.yandex-team.ru/api/changeForward.php"
STAFF_API       = "http://api.staff.yandex-team.ru/v3/"
GROUP_ADMIN_NAME      = "yandex_monetize_search_direct_interface_exp"
GROUP_DEV  = "yandex_monetize_tech_dev_modadv_modadv" 
# memcache node prefix
MEMC_PREFIX     = 'direct_' 

def get_with_cookie(url, cookie):
    opener = urllib2.build_opener()
    opener.addheaders.append(('Cookie','Session_id=%s' % cookie))
    data=opener.open(url)
    return data.read()

def release_message():
    today   = int(datetime.datetime.now().weekday())
    hour    = int(datetime.datetime.now().strftime('%H'))

    locale.setlocale(locale.LC_ALL,'ru_RU.UTF8')
    day_of_week = calendar.day_name[today].lower()
    msg=''
    if today > 4:
        msg += '<h2>Сегодня %s, а значит ваш пакет в продашн поедет только на следующей неделе.</h2>' % day_of_week
    elif today == 4 and hour > 18:
        msg += '<h2>Сейчас уже позже 6 часов вечера пятницы, все тикеты в продакшн будут выложены в понедельник.</h2>'
    elif hour > 18 or hour < 11:
        msg += '<h2>Уже больше 6 часов вечера, все тикеты будут выложены завтра.</h2>'
    return msg

def duty(environ, start_response):
    # Get session_id from request (w/o checks)
    cookies=Cookie.SimpleCookie()
    cookies.load(environ['HTTP_COOKIE'])
    sess_id=cookies['Session_id'].value

    memc = memcache.Client(['127.0.0.1:11211'], debug=1);

    if environ['QUERY_STRING']:
        (action, param) = environ['QUERY_STRING'].split('=')
        # Change on-call user
        if action == 'set_admin_duty':
            # Invalidate all caches
            memc.delete(MEMC_PREFIX + 'admin_duty_data')
            memc.delete(MEMC_PREFIX + 'admin_group_users')
            
            # Get new on-call user phone and update forward
            url=STAFF_API+'/persons?_fields=login,work_phone,name&login='+param
            data = json.loads(get_with_cookie(url,sess_id))
            duty_phone = data['result'][0]['work_phone']
            url = "%s?num=%s&fnum=55%d" % (FORWARD_API, FORWARD_ADMIN_NUMBER, duty_phone)
            urllib2.urlopen(url)

            status = '302 Moved Temporarily'
            response_headers = [
                ('Location','/'),
            ]
            start_response(status, response_headers)
            return ''
        if action == 'set_dev_duty':
            # Invalidate all caches
            memc.delete(MEMC_PREFIX + 'dev_duty_data')
            memc.delete(MEMC_PREFIX + 'dev_group_users')
            
            # Get new on-call user phone and update forward
            url=STAFF_API+'/persons?_fields=login,work_phone,name&login='+param
            data = json.loads(get_with_cookie(url,sess_id))
            duty_phone = data['result'][0]['work_phone']
            url = "%s?num=%s&fnum=55%d" % (FORWARD_API, FORWARD_DEV_NUMBER, duty_phone)
            urllib2.urlopen(url)

            status = '302 Moved Temporarily'
            response_headers = [
                ('Location','/'),
            ]
            start_response(status, response_headers)
            return ''

    m_result = memc.get(MEMC_PREFIX + 'admin_duty_data')
    if not m_result:
        # Find current forward numer:
        url = FORWARD_API+"/?getForward&num="+FORWARD_ADMIN_NUMBER
        current_forward= str(urllib2.urlopen(url).read()).splitlines()[0]

        # Strip 55 prefix
        if len(current_forward) == 6:
            current_forward = current_forward[2:6]
    
        # Find on-call user data by forward phone:
        url=STAFF_API+'/persons?_fields=login,work_phone,name&work_phone='+current_forward
        admin_duty_data = json.loads(get_with_cookie(url,sess_id))
 
        memc.set(MEMC_PREFIX + 'admin_duty_data',admin_duty_data,600)
    else:
        admin_duty_data = m_result

    m_result = memc.get(MEMC_PREFIX + 'dev_duty_data')
    if not m_result:
        # Find current forward numer:
        url = FORWARD_API+"/?getForward&num="+FORWARD_DEV_NUMBER
        current_forward= str(urllib2.urlopen(url).read()).splitlines()[0]

        # Strip 55 prefix
        if len(current_forward) == 6:
            current_forward = current_forward[2:6]
    
        # Find on-call user data by forward phone:
        url=STAFF_API+'/persons?_fields=login,work_phone,name&official.is_dismissed=false&work_phone='+current_forward
        dev_duty_data = json.loads(get_with_cookie(url,sess_id))
 
        memc.set(MEMC_PREFIX + 'dev_duty_data',dev_duty_data,600)
    else:
        dev_duty_data = m_result

    m_result = memc.get(MEMC_PREFIX + 'admin_group_users')
    if not m_result:
        # Find users in group:
        url=STAFF_API+'/groupmembership?_fields=person&group.url=' + GROUP_ADMIN_NAME
        possible_users=json.loads(get_with_cookie(url,sess_id))
    
        admin_group_users=[ x['person']['login'] for x in possible_users['result'] \
                        if x['person']['official']['is_dismissed'] == False \
                        and x['person']['login'] != admin_duty_data['result'][0]['login'] ]

        memc.set(MEMC_PREFIX + 'admin_group_users',admin_group_users,3600)
    else:
        admin_group_users=m_result

    m_result = memc.get(MEMC_PREFIX + 'dev_group_users')
    if not m_result:
        # Find users in group:
        url=STAFF_API+'/groupmembership?_fields=person&group.url=' + GROUP_DEV
        possible_users=json.loads(get_with_cookie(url,sess_id))    
        dev_group_users=[ x['person']['login'] for x in possible_users['result'] \
                        if x['person']['official']['is_dismissed'] == False \
                        and x['person']['login'] != dev_duty_data['result'][0]['login'] ]

 #       dev_group_users=[]
 #       dev_group_users.extend(GROUP_DEV)
        memc.set(MEMC_PREFIX + 'dev_group_users',dev_group_users,3600)

    else:
        dev_group_users=m_result
    
    add_msg = release_message()
    
    # Render template
    env     = Environment( loader=FileSystemLoader('/var/www/duty/templates/', encoding='utf-8'), extensions=["jinja2.ext.do",] )
    tpl     = env.get_template( "index.tpl" )
    data    = tpl.render( admin_duty=admin_duty_data, additional_message = add_msg, admin_users=admin_group_users, dev_users=dev_group_users, dev_duty=dev_duty_data )
    
    status = '200 OK'
    response_headers = [
        ('Content-type','text/html; charset=utf-8'),
        # Doesn't work with UTF
        # ('Content-Length', str(len(data)))
    ]
    start_response(status, response_headers)
    return iter([data.encode("UTF-8")])
