#!/usr/bin/perl
use strict;
use warnings;
use Socket qw(PF_INET SOCK_STREAM INADDR_LOOPBACK pack_sockaddr_in);

my $iostat_interval = 60;
my $host = qx(hostname -f);
chomp $host;
socket(my $socket, PF_INET, SOCK_STREAM, getprotobyname("tcp")) or die "socket: $!";
connect($socket, pack_sockaddr_in(42000, INADDR_LOOPBACK)) or die "connect: $!";

sub send_to_graphite {
  my @data = @_;
  print $socket join("\n", @data) . "\n";
}

my ($timestamp, @columns);
open my $fh, '-|', "iostat -dxkN $iostat_interval";
while (my $line = <$fh>) {
  chomp $line;
  if ($line =~ /^Device:/) {
    $timestamp = time();
    @columns = split /\h+/, $line;
    next;
  }
  next if $line =~ /^\h*$/ or not @columns;

  my @data = ();
  my @dev_stat = split /\h+/, $line;
  for (my $id = 1; $id < scalar @dev_stat; $id++) {
    my @nodes = map { s/[^0-9a-zA-Z-]/_/g; s/^_+//; $_ } ($host, $dev_stat[0], $columns[$id]);
    push @data, sprintf "one_min.%s.iostat_full.%s.%s %d %d", (@nodes, int($dev_stat[$id] + 0.5), $timestamp);
  }
  send_to_graphite(@data) if @data;
}
