#!/usr/bin/env perl
use strict;
use warnings;

chomp (my $host = qx(hostname -f));
$host =~ s/[^0-9a-zA-Z-]/_/g;
my %logs;
while (<>) {
    chomp;
    s/^\s+|\s+\n$//g;
    next if ! $_ || /^#/;
    my ($graphite_path, $log_path) = split / /, $_, 2;
    my ($log_name) = ($log_path =~ m!([^/]+)$!);
    $log_name =~ s/[^0-9a-zA-Z-]/_/g;
    $graphite_path =~ s/\$hostname\b/$host/;
    $graphite_path =~ s/\$logname\b/$log_name/;
    $graphite_path = join '.', map { s/[^0-9a-zA-Z-]/_/g; $_ } split /\./, $graphite_path;
    $logs{$log_path} = $graphite_path;
}

while (my($log, $path) = each %logs) {
    my @log_stat = stat($log);
    printf "$path $log_stat[7] %d\n", int(time / 60) * 60;
}
