#!/usr/bin/perl
use strict;
use warnings;
# 32765  0.0 00:05:37  9-02:02:49 reporter (main (DelayedContactInfoAggregator main))
# root@modback01g:~# ps -e -o pid,pcpu,cputime,etime,cmd

sub fix_ps_time {
  my ($time) = @_;
  my @t = ($time =~ /(?:(\d+)-)?(?:(\d+)(?=:\d\d:\d\d):)?(\d+):(\d+)$/);
  @t = map { defined($_) ? $_ : 0 } @t;
  return $t[0]*60*60*24 + $t[1]*60*60 + $t[2]*60 + $t[3];
}

open(my $ps, '-|', 'ps -e -o pid,c,cputime,etime,cmd | tail -n+2') or die;
while (<$ps>) {
  chomp;
  my ($pid, $pcpu, $cputime, $etime, $cmd) = (/^\s*(\d+)\s+([0-9.]+)\s+([0-9:-]+)\s+([0-9:-]+)\s+(.*)$/);
  $cputime = fix_ps_time($cputime);
  $etime = fix_ps_time($etime);
  print time . " $pid $pcpu $cputime $etime $cmd\n";
}
