#!/bin/bash

port=$1

js=$(
cat<<EOF
load("/root/.mongorc.js");
rsm = rs.status().members;
good_state = ["PRIMARY", "SECONDARY", "ARBITER"]
strange_state = ["STARTUP", "RECOVERING", "ROLLBACK"]
function check_state() {
  for (var i=0,len=rsm.length; i < len; i++) {
    if (rsm[i].name == rs.isMaster().me) {
      my_state = rsm[i].stateStr
      for (var j=0; j < good_state.length; j++) {
        if (my_state.indexOf(good_state[j]) != -1) { 
          print("0;OK " + my_state)
          return
        }
      }
      for (var j=0; j < strange_state.length; j++) {
        if (my_state.indexOf(strange_state[j]) != -1) {
          print("2;Bad status " + my_state)
          return
        }
      }
      print("2;Bad status " + my_state)
      return
    }
  }
}
check_state()
EOF
)

[ -z $port ] && port=$(awk -F "=" '/port/ { print $2}' /etc/mongo/mongodb-modd*)

sudo mongo --port $port --quiet --eval "$js"

