#!/usr/bin/python
import time
import socket
import sys
from subprocess import Popen, PIPE
from string import maketrans

def send_to_graphite(metric, value):
    value = int(value)
    normalized_fqdn = socket.getfqdn().translate(maketrans('.','_'))
    data = "one_min." + normalized_fqdn + "." + metric + " " + str(value) + " " + str(int(time.time()))
    print data

ps_grep = "ps -e -o min_flt,maj_flt,cmd | perl -lne 's/(\t|\s)+/ /g; m|^\d+ +\d+ +/usr/bin/mongo| && print'"
ps_out = None
try:
    ps_out = Popen(ps_grep, shell=True, stdout=PIPE).communicate()[0].split("\n")
except:
    sys.exit(1)

for ps in ps_out:
    try:
        mongo_cmd = ps.split()[2:]
        mongo_pagefaults = ps.split()[:2]
    
        conf_name = mongo_cmd[mongo_cmd.index('--config') + 1]
        if conf_name.rfind('/') > 0:
            conf_name = conf_name[conf_name.rfind('/') + 1:]
        if conf_name.rfind('.conf') > 0:
            conf_name = conf_name[:conf_name.rfind('.conf')]
        if not conf_name:
            continue
        
        send_to_graphite(conf_name + ".pagefaults.min_flt", mongo_pagefaults[0])
        send_to_graphite(conf_name + ".pagefaults.maj_flt", mongo_pagefaults[1])
    except:
        continue
