#!/bin/bash

port=$1

js=$(
cat<<EOF
load("{{ auth_file }}");
rsm = rs.status().members;
for (var i=0,len=rsm.length; i<len; i++) {
  if (rsm[i].name == rs.isMaster().me) { print(rsm[i].stateStr); break; }
}
EOF
)

status=$(sudo mongo --port $port --quiet --eval "$js" 2>&1 | tail -1);

case "$status" in PRIMARY|SECONDARY)
  echo "0;OK $status" ;;
  STARTUP*|RECOVERING|ROLLBACK|ARBITER) echo "1;Strange status $status" ;;
  *) echo "2;Bad status $status" ;;
esac
