# приезжает из плейбуки svn+ssh://svn.yandex.ru/direct-admin-svn/trunk/ansible/roles/mysql-grants/tasks/main.yml
# запускается из /usr/share/mysql-grants/grant2sql
# меняет пароли, записанные в конфиге грантилки как file:<filename> на содержимое файла <filename>
for my $user (keys %$Users) {
    my ($password_file) = $Users->{$user} =~ /^file:(.*)/;
    if ($password_file) {
        open my $fh, '<', $password_file or die "can't open password file $password_file for user $user: $!";
        # после успешного open значение $!:
        #   - может быть не 0 ( https://rt.perl.org/Public/Bug/Display.html?id=124232 )
        #   - бессмысленно (см perldoc perlvar)
        # grant2sql проверяет $! и падает, если оно не 0, поэтому $! сбрасывается здесь
        undef $!;
        chomp(my $password = <$fh>);
        close $fh;
        $Users->{$user} = $password;
    }
}
