#!/bin/bash
# Скрипт проверяет последнее изменение между репозиторием и файлом на сервере. 
# При несоответствии загорается лампочка в мониторинге.

CONF='/etc/mysql-grants.conf'
export LC_USER="robot-direct-admin"
export SSH_KEY="/home/$LC_USER/.ssh/id_dsa"
export SVN_SSH="ssh -l $LC_USER -o UserKnownHostsFile=/dev/null -o ConnectTimeout=15 -o StrictHostKeyChecking=no -i $SSH_KEY" 
EXIT_CODE=0

exec < $CONF
while read key value; do
   IFS=' '
   key=${key// /}
   key=${key^^}
   value=${value//= /}
   export "$key"="$value"
done

SVN_LIST=$(svn list $SVN 2>/dev/null | xargs echo)
[ -z "$SVN_LIST" ] && echo '0;SVN not working' && exit 1 

for FILENAME in $SVN_LIST; do

   CACHE=$DIRECTORY'/'$FILENAME
   NEW_SVN=$SVN'/'$FILENAME

   #SVN_DATE=$(svn info $NEW_SVN 2>/dev/null | grep -i 'Last Changed Rev')
   #[ -z "$SVN_DATE" ] && echo '1;SVN not working' && exit 1

   [ ! -f "$CACHE" ] && echo "1;Not found $CACHE" && exit 0
   
   FILE_DATE=$(svn info $CACHE 2>/dev/null | grep -i 'Last Changed Rev') 
   [ -z "$FILE_DATE" ] && echo '0;SVN not working' && exit 1

   SVN_DIFF=$(svn diff $CACHE | wc -l)
   [ -z "$SVN_DIFF" ] && echo "1;Cache $CACHE is old. Please sync SVN." && exit 2
   #[ "$FILE_DATE" = "$SVN_DATE" ] || EXIT_CODE=1

done

#[ "$EXIT_CODE" != 0 ] && echo '1;Cache is old. Please sync SVN.' && exit 1
#[ "$EXIT_CODE" = 0 ] && 
/usr/bin/check-mysql-grants.py
