#!/usr/bin/python

from optparse import OptionParser
from telnetlib import *
from threading import Thread
from threading import Lock
from Queue import Queue
import os, socket

HOST = 'localhost'
PORT = 2024
LOAD_FILE = '/local/metric.dump'
TMP_FILE= '/local/metric.dump.done'

def go(i, q, lock, fileDone):
    while True:
        path = q.get()

        while True:
            try:
               carbon.write(path)
               break
            except Exception:
               carbon = Telnet(options.host, options.port)
               continue

        with open(fileDone, 'a+') as _file:
            _file.write( path )
        q.task_done()


if __name__ == '__main__':

    parser = OptionParser()
    parser.add_option("-H", "--host", dest="host", help="Destination address graphite server. Default: None", type="str")
    parser.add_option("-P", "--port", dest="port", help="Destination port graphite server. Default: 2024", type="int", default=PORT)
    parser.add_option("-f", "--file", dest="lfile", help="Load metrics file for send. Default: /local/metric.dump", type="str", default=LOAD_FILE)
    parser.add_option("-t", "--tmp", dest="tfile", help="File with posted metrics. Default: /local/metric.dump.done", type="str", default=TMP_FILE)

    (options, args) = parser.parse_args()

    load_job_metric = open(options.lfile).readlines()

    queue = Queue()
    lock = Lock()
    num_threads = 1000

    load_done_metric = open(options.tfile).readlines() if os.path.exists(options.tfile) else list()
    load_job_metric = list(set(load_job_metric)-set(load_done_metric))

    for i in range(num_threads):
        worker = Thread(target=go, args=(i, queue, lock, options.tfile))
        worker.setDaemon(True)
        worker.start()
    
    [ queue.put(m) for m in load_job_metric ]
    queue.join()

