#!/usr/bin/python
# -*- coding: utf8 -*-

import urllib
import urllib2
import json
import time

'''
Скрипт расчитывает тайминги интерфейса и API для аудиторов.
Графики живут на дашбоарде http://ppcgraphite.yandex.ru/dashboard/#Direct_SLA.
'''

chUrl='https://ppchouse-cloud.direct.yandex.net:8443/?user=readonly&query=%s'

commonLimits='''log_time > toDateTime(toInt64(now()) - 3660) and
                log_time < toDateTime(toInt64(now()) - 60) and
                length(upstream_response_time) != 0
'''

methodsDirect = ('showCamp', 'showCamps', 'editCamp', 'saveCamp', 'bannersMultiSave');
statsMethodDirect = ('showCampStat');
methodsSoap = (
  'direct.json-api/GetBannerPhrasesFilter',
  'direct.json-api/GetBanners',
  'direct.json-api/SetAutoPrice',
  'direct.json-api/GetBannerPhrases',
  'direct.json-api/UpdatePrices',
  'direct.json-api/CreateOrUpdateBanners',
  'direct.json-api/GetCampaignsParams',
  'direct.json-api/GetCampaignsList',
  'direct.json-api/GetSummaryStat',
  'direct.json-api/GetCampaignsListFilter',
  'direct.json-api/GetClientsList',
  'direct.json-api/CreateNewReport',
  'direct.json-api/GetReportList',
  'direct.json-api/GetBalance',
  'direct.json-api/PayCampaigns',
  'direct.json-api/TransferMoney',
  'direct.json-api/GetCampaignParams',
  'direct.json-api/GetBannersStat',
  'direct.json-api/CreateOrUpdateCampaign',
  'direct.json-api/campaigns',
  'direct.json-api/adgroups',
  'direct.json-api/ads',
  'direct.json-api/vcards',
  'direct.json-api/bids',
  'direct.json-api/keywords',
  'direct.json-api/sitelinks',
)

def getJsonFromCh(query):
    q_enc=urllib.quote(query)
    request = urllib2.Request(chUrl % q_enc)
    # FIXME 'ретрай'
    try:
        response = urllib2.urlopen(request).read().rstrip()
    except:
        response = urllib2.urlopen(request).read().rstrip()

    return json.loads(response)

def graphiteFormat(metric_name, value ):
    ts=int(time.time())
    print "%s %s %s" % (metric_name, value, ts)

def showTimings(vhost_mask, vhost_name, method):
    prcs=[0.5,0.75,0.9,0.95,0.97,0.98,0.99,1]
    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""position(upstream_http_x_accel_info, '%s') > 0""" % x for x in method) + \
                ") format JSON"
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.sla_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

def showStatTimings(vhost_mask, vhost_name, method):
    prcs=[0.5,0.75,0.9,0.95,0.97,0.98,0.99,1]
    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""position(upstream_http_x_accel_info, '%s') > 0""" % x for x in method) + \
                """) and position(request_body, 'stat_type=campdate') == 0 format JSON"""
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.remotestat_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

    query   = """select quantilesTiming(%s)(request_time*1000) as timings from default.nginx_access where
                %s and
                vhost = '%s' and (""" % (",".join([str(x) for x in prcs]), commonLimits, vhost_mask) + \
                " or ".join("""position(upstream_http_x_accel_info, '%s') > 0""" % x for x in method) + \
                """) and position(request_body, 'stat_type=campdate') > 0 format JSON"""
    data=getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs,js['timings']):
                graphiteFormat( "one_min.%s_yandex_ru.localstat_timings.%s" % ( vhost_name, int(prc*100)), prc_timing)

if __name__ == '__main__':
    showTimings('direct.yandex.ru', 'direct', methodsDirect)
    showStatTimings('direct.yandex.ru', 'direct', statsMethodDirect)
    showTimings('api.direct.yandex.ru', 'api_direct', methodsSoap)
