#-*- coding: utf-8 -*-
import os
import re
import locale
import calendar
import datetime

# После того как сделают дырки в апи центра можно будет узнавать дежурного по номеру через апишку
FORWARD_API     = "http://bot.yandex-team.ru/api/changeForward.php"
FORWARD_NUMBER  = 1601

def change_forward(forward_to):
    url = "%s?num=%d&fnum=%d" % (FORWARD_API, args.forward_from_number, forward_to)
    return urllib.urlopen(url).read()

def get_current_forward():
    url = "%s?num=%d&getForward" % (FORWARD_API, args.forward_from_number)
    return int(urllib.urlopen(url).read())

def find_duty():
    base='/var/log/duty-admin/'
    
    files=os.listdir(base)

    metrika_logs    = filter(lambda x: x.split('.')[0]=='duty-metrika',files)
    last_file       = base + sorted(metrika_logs,key=lambda x: x.split('.')[1], reverse=True)[0]
 
    duty_re='.*changed to login:\s([^\s]+).*'
    reg=re.compile(duty_re)
    
    fh=open(last_file,'r')
    lines = fh.readlines()
    fh.close()

    for line in lines.__reversed__():
        m=reg.match(line)
        if m:
            return m.group(1)
    return 'unknown'

def release_message():
    today   = int(datetime.datetime.now().weekday())
    hour    = int(datetime.datetime.now().strftime('%H'))

    locale.setlocale(locale.LC_ALL,'ru_RU.UTF8')
    day_of_week = calendar.day_name[today]
    msg=''
    if today > 3:
        msg += '<h2>Сегодня %s, а значит ваш пакет в продашн поедет только на следующей неделе.</h2>' % day_of_week
    elif today == 3 and hour > 19:
        msg += '<h2>Сейчас уже позже 7 часов вечера четверга, все тикеты в продакшн будут выложены в понедельник.</h2>'
    elif hour > 19 or hour < 11:
        msg += '<h2>Уже больше 7 часов вечера, все тикеты будут выложены завтра.</h2>'
    return msg


def duty(environ, start_response):
    current_duty = find_duty()

    # Переписать на jinja!
    data='''<html>
    <head>
    <!-- Latest compiled and minified CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css">
    <script type="text/javascript" src="http://yandex.st/jquery/1.7.1/jquery.min.js"></script>
    <script type="text/javascript" src="http://center.yandex-team.ru/media/staff-card/_staff-card.css"></script>
    <!--[if gt IE 7]><!--><link rel="stylesheet" href="http://center.yandex-team.ru/media/staff-card/_staff-card.css" /><!--<![endif]-->
    <!--[if lt IE 8]><link rel="stylesheet" href="http://center.yandex-team.ru/media/staff-card/_staff-card.ie.css"><![endif]-->
    <script type="text/javascript" src="http://center.yandex-team.ru/media/staff-card/_staff-card.js"></script>

    <title>Админы Яндекс.Метрики</title>
    </head>
    <body>

    <div class="container">
        <div class="page-header">
            <h1>На этой неделе дежурит <a class="auto-person-card" href="//staff.yandex-team.ru/%(login)s" data-login="%(login)s">%(login)s@</a></h1>

        </div>
        %(weekend_msg)s
        <p class="lead">Напомним как и когда мы выкладываем пакеты: <a href='https://wiki.yandex-team.ru/JandexMetrika/admin/ReleaseRules'>wiki/JandexMetrika/admin/ReleaseRules</a></p>
    </div>

    <div class="footer">
      <div class="container">
        <p class="text-muted"><a href='xmpp:%(login)s@yandex-team.ru'>Написать</a> в jabber дежурному.</p>
      </div>
    </div>

    </body>
    </html>''' % { 'login': current_duty, 'weekend_msg': release_message() }
    
    status = '200 OK'
    response_headers = [
        ('Content-type','text/html; charset=utf-8'),
        ('Content-Length', str(len(data)))
    ]
    start_response(status, response_headers)
    return iter([data])

def set_duty(environ, start_response):
    if not environ['QUERY_STRING']:
        data='''Необходимо указать логин пользователя.
                Например:
                /set_duty?velom
        '''
    else:
        from os import system
        from time import strftime
        admin=environ['QUERY_STRING']
        system("/usr/lib/duty-admin/duty-admin.py -c ghryUifhTuyGJituet -g mtrs -n 1601 -l %s -s /tmp/duty-metrica.sched.dat -u /tmp/duty-metrica.users.dat >> /var/log/duty-admin/duty-metrika.%s" % ( admin, strftime('%Y%m%d') ) )
        data='Duty changed to %s' % admin

    status = '200 OK'
    response_headers = [
        ('Content-type','text/html; charset=utf-8'),
        ('Content-Length', str(len(data)))
    ]
    start_response(status, response_headers)
    return iter([data])
