#!/usr/bin/python
# -*- coding: utf8 -*-
#
# скрипт рисует графики таймингов сервисов по данным из кликхауса (туда они попадают с серверов через mtrs-logpusher)
# при добавлении нового балансера нужно дописать сответствующий вызов showTimings в __main__ по аналогии

import urllib
import urllib2
import json
import time
import os

chUrl='http://localhost:8123/?query=%s'

delay=120

#commonLimits = '''day = today() and
#                  date >= toStartOfMinute(toDateTime(now() - 60 - %(delay)d )) and
#                  date < toStartOfMinute(toDateTime(now() - %(delay)d )) and
#                  static = 0
#               ''' % {"delay": delay}
commonLimits = 'static = 0'

def log_debug(msg):
    if not os.environ.get('DEBUG'):
        return
    print 'DEBUG: ' + msg.replace('\n', ' ').replace('\r', '') + "\n"

def getJsonFromCh(query):
    q_enc=urllib.quote(query)
    request = urllib2.Request(chUrl % q_enc)
    # FIXME 'ретрай'
    try:
        response = urllib2.urlopen(request).read().rstrip()
    except:
        response = urllib2.urlopen(request).read().rstrip()

    return json.loads(response)

def graphiteFormat(path_items, value):
    ts = int(time.time()) - delay
    print "%s %s %s" % ('.'.join([str(x) for x in path_items]), int(value), ts)

def showTimings(vhost_mask, graphite_prefix, table='ppclogpusher.logs', group_by='dc'):

    query = """select %s, count()/60 as rps from %s where
               %s and
               vhost like '%s'
               group by %s with totals format JSON""" % (group_by, table, commonLimits, vhost_mask, group_by)
    log_debug('rps by dc: ' + query)

    sum_rps = 0
    for js in getJsonFromCh(query)['data']:
        graphiteFormat((graphite_prefix, group_by, js[group_by].lower().replace('.', '_'), 'rps'), js['rps'])
        sum_rps += js['rps']

    if group_by == 'dc':
        graphiteFormat((graphite_prefix, 'totals', 'rps'), sum_rps)

    query = """select %s, code, count() as cnt from %s where
               %s and
               vhost like '%s'
               group by %s, code format JSON""" % (group_by, table, commonLimits, vhost_mask, group_by)
    log_debug('http codes by dc: ' + query)

    for js in getJsonFromCh(query)['data']:
        graphiteFormat((graphite_prefix, group_by, js[group_by].lower().replace('.', '_'), 'codes', js['code']), js['cnt'])

    prcs = [0.5, 0.6, 0.9, 0.95, 0.98, 0.99, 1]
    query = """select %s, quantiles(%s)(time) as timings from %s where
               %s and
               vhost like '%s'
               group by %s with totals format JSON""" % (group_by, ",".join([str(x) for x in prcs]), table, commonLimits, vhost_mask, group_by)
    log_debug('timings by dc: ' + query)

    data = getJsonFromCh(query)
    for js in data['data']:
        for (prc, prc_timing) in zip(prcs, js['timings']):
            graphiteFormat((graphite_prefix, group_by, js[group_by].lower().replace('.', '_'), 'timings', int(prc*100)), prc_timing)

    if group_by != 'dc':
        return
    # Данных может не быть, если не было запросов
    try:
        for (prc, prc_timing) in zip(prcs, data['totals']['timings']):
            graphiteFormat((graphite_prefix, 'totals', 'timings', int(prc*100)), prc_timing)
    except:
        pass


if __name__ == '__main__':
    for field in ['dc', 'hostname']:
        showTimings('catalogia-phrases', 'ppclogpusher.catalogia-phrases', table='ppclogpusher.logs_catalogia', group_by=field)
