#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim: set expandtab:tabstop=4:softtabstop=4:shiftwidth=4:nowrap

import os
import sys
import argparse
from directadmon.directadmin_monitorings import *

FLAP_10_MIN = FlapOptions(stable=60*10, critical=60*30)

(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))
CONDUCTOR_GROUP='ppcdevs'

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=cgroups_to_children([CONDUCTOR_GROUP]), token=args.token, default_kwargs=APPDUTY_ONLY_CHECK_NP)
checks.append_common()
checks.append_walle()

# unispace есть в append_common
for svc in ['load_average', 'mem_used']:
    # проще заводить агрегат над агрегатом, даже если он один =(
    checks.append_aggr(service=svc, flaps_config=FLAP_10_MIN, **juggler_merge(UNREACH_READY, APPDUTY_ONLY_CHECK_NP))
    ##checks.append_aggr_single(service=svc, tags=["directadmin_TV", "direct_group_sre"])

checks.append_aggr(service='scripts.issues_reminder.working', ttl=90 * 60, flaps_config=FLAP_10_MIN, **hash_merge(UNREACH_READY, LOGIC_AND))
checks.append_aggr(
    service='dt-deploy-notifier.working',
    ttl=90 * 60,
    flaps_config=FLAP_10_MIN,
    **hash_merge(UNREACH_READY, LOGIC_AND, {'tags': ['direct-appduty-tv_np']})
)

checks.apply(dry_run=not args.apply, pretty=args.pretty)
