#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

aggr_host = HOST
aggr_kwargs = DEFAULT_CHECK #Вариант CALLING_CHECK
aggr_kwargs = juggler_merge({'tags': ['direct-%s-health' % HOST ]}, aggr_kwargs)
aggr_kwargs['tags'] = [t for t in aggr_kwargs['tags'] if t != 'directadmin_TV']  # убираем с основоного tv-дашборда, там будут только общие проверки
aggr_kwargs['ttl'] = SOLOMON_TTL


children = []
childrens = []
for i in ['man', 'vla']:
    children.append(Child(host='direct.solomon-alert', service='mdb-ppchouse-testing-%s' % i))
checks.append(children=children, host=aggr_host, service='ppchouse-space-used', **aggr_kwargs)

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
