#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

checks_file = '/etc/direct-access-check/direct_checks.yaml'
with open(checks_file) as f:
    rules_conf = yaml.load(f)

top_level_children = []
for rule in rules_conf:
    if not( len(rule['applicable']) == 1 and rule['applicable'][0] == 'conductor/ppcdevs' ):
        continue

    juggler_service = 'access_check.'+rule['juggler_event_name']
    child = Child(host='ppcdevs', group_type='CGROUP', service=juggler_service)
    checks.append(
            host=HOST,
            service=juggler_service,
            children=[child],
            tags = ['direct-access-check-np'],
            aggregator = "more_than_limit_is_crit",
            aggregator_kwargs = {
                'limit': 2,
                },
            )

slbs = ["direct-apisteps-proxy_balancer", "direct-balance-test-proxy_balancer", "direct-handles_balancer", "radar_backend_balancer", "direct_test_allin_namespace"]
slb_childs = []
for slb in slbs:
    for response_type in ['400', '500']:
        svc = {'service': 'slb-l7-%s' % response_type}
        child = Child(host='yasm_alert', service='direct-l7-%s.%s' % (response_type, slb))
        slb_childs.append(child)

       # self.append(host=aggr, children=[child], **hash_merge(self.default_check, svc))
    top_level_children = []
    svc = {'service': 'slb-l7-hw'}
    awacs_namespace_juggler_name = slb.replace('_','-').replace('.','-')
    for check in ['cpu_wait_cores', 'mem_usage', 'cpu_usage', 'logs_vol_usage']:
        children = []
        for dc in ['sas', 'man', 'vla']:
            children.append(Child(host='awacs.%s.%s' % (awacs_namespace_juggler_name, dc), service=check))
        checks.append(host='direct.np_slb.%s' % awacs_namespace_juggler_name, children=children, service=check) # не хотим поДЦшно смотреть, собираем агрегаты в 1 на каждую метричку
        top_level_children.append(Child(host='direct.np_slb.%s' % awacs_namespace_juggler_name, service=check))# собираем детей из поДЦшных агрегатов
    checks.append(host='direct.np_slb.%s' % awacs_namespace_juggler_name, children=top_level_children, **hash_merge(checks.default_check, svc)) # - здесь получаются понеймспесовые(побалансерные) агрегаты
    slb_childs.append(Child(host='direct.np_slb.%s' % awacs_namespace_juggler_name, service=svc.get("service")))
checks.append(service = 'ts-l7-slb', host=HOST, children=slb_childs, tags = ['direct-slb-np'], aggregator = "logic_or")



### применяем проверки
checks.apply(dry_run=not args.apply, pretty=args.pretty)
